/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.display.blocks.BlockLocator;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.layers.Layer;

public class OverblockLayer
implements Layer {
    private BlockLocator blockLocator;
    private int termCode = -1;
    private final List<Rectangle> rectList = new ArrayList<Rectangle>();
    private OverblockPainter overblockPainter = new SoftPainter();
    private String name;
    private int index;

    @Override
    public void setBlockLocator(BlockLocator blockLocator) {
        this.blockLocator = blockLocator;
    }

    public void setOverBlockPainter(OverblockPainter overblockPainter) {
        this.overblockPainter = overblockPainter;
    }

    public void setTermCode(int termCode) {
        this.termCode = termCode;
    }

    @Override
    public void update() {
        this.rectList.clear();
        if (this.termCode != -1) {
            for (LibelleBlock libelleBlock : this.blockLocator.getLiaisonBlockList()) {
                if (libelleBlock.getTerm().getCode() != this.termCode) continue;
                this.rectList.add(libelleBlock.getRectangle());
            }
        }
    }

    @Override
    public void paintLayer(Graphics2D g) {
        int size = this.rectList.size();
        for (int i = 0; i < size; ++i) {
            this.overblockPainter.paintRectangle(g, this.rectList.get(i));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    private static class SoftPainter
    implements OverblockPainter {
        Color softWhite = new Color(255, 255, 255, 128);

        private SoftPainter() {
        }

        @Override
        public void paintRectangle(Graphics2D g, Rectangle rectangle) {
            g.setColor(this.softWhite);
            g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static interface OverblockPainter {
        public void paintRectangle(Graphics2D var1, Rectangle var2);
    }
}

