/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.descripteurs;

import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;

public class DescripteursUtils {
    public static final DescripteurList EMPTY_DESCRIPTEUR_LIST = new EmptyDescripteurList();

    private DescripteursUtils() {
    }

    public static int getFamilleSize(Descripteur descripteur) {
        Descripteurs descs = descripteur.getDescripteurs();
        DescripteurList descripteurList = descs.getInFamilleDescripteurList(descripteur.getFamille());
        if (descripteurList == null) {
            return 0;
        }
        return descripteurList.getDescripteurCount();
    }

    public static DescripteurList getInFamilleDescripteurList(Contexte famille) {
        Descripteurs descs = famille.getAtlas().getDescripteurs();
        return descs.getInFamilleDescripteurList(famille);
    }

    public static Descripteur getFirstDescripteur(Descripteurs descripteurs) {
        Structure structure = descripteurs.getAtlas().getStructure();
        DescripteurList listesansfamille = descripteurs.getInFamilleDescripteurList(StructureUtils.getSansfamilleContexte(structure));
        if (listesansfamille.getDescripteurCount() > 0) {
            return listesansfamille.getDescripteur(0);
        }
        ContexteList familleList = StructureUtils.getFamilleList(structure, false);
        int familleCount = familleList.getContexteCount();
        for (int i = 0; i < familleCount; ++i) {
            Contexte famille = familleList.getContexte(i);
            DescripteurList desclist = descripteurs.getInFamilleDescripteurList(famille);
            if (desclist.getDescripteurCount() <= 0) continue;
            return desclist.getDescripteur(0);
        }
        return null;
    }

    public static int indexOf(DescripteurList descripteurList, Descripteur descripteur) {
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            if (!descripteurList.getDescripteur(i).equals(descripteur)) continue;
            return i;
        }
        return -1;
    }

    public static DescripteurList toDescripteurList(Descripteur[] array) {
        return new ArrayDescripteurList(array);
    }

    public static List<DescripteurList> getListOfDescripteurList(Descripteurs descripteurs) {
        ArrayList<DescripteurList> list = new ArrayList<DescripteurList>();
        Grille famille = descripteurs.getAtlas().getStructure().getGrille("");
        ContexteList contexteList = famille.getFirstLevelContexteList();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            DescripteursUtils.addFamilleList(descripteurs, contexteList.getContexte(i), list);
        }
        DescripteursUtils.addFamilleList(descripteurs, StructureUtils.getSansfamilleContexte(descripteurs.getAtlas().getStructure()), list);
        return list;
    }

    private static void addFamilleList(Descripteurs descripteurs, Contexte famille, List<DescripteurList> list) {
        DescripteurList descList = descripteurs.getInFamilleDescripteurList(famille);
        if (descList.getDescripteurCount() > 0) {
            list.add(descList);
        }
        ContexteList children = famille.getChildren();
        int contexteCount = children.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            DescripteursUtils.addFamilleList(descripteurs, children.getContexte(i), list);
        }
    }

    private static class ArrayDescripteurList
    implements DescripteurList {
        private Descripteur[] array;

        private ArrayDescripteurList(Descripteur[] array) {
            this.array = array;
        }

        @Override
        public int getDescripteurCount() {
            return this.array.length;
        }

        @Override
        public Descripteur getDescripteur(int i) {
            return this.array[i];
        }
    }

    private static class EmptyDescripteurList
    implements DescripteurList {
        private EmptyDescripteurList() {
        }

        @Override
        public int getDescripteurCount() {
            return 0;
        }

        @Override
        public Descripteur getDescripteur(int i) {
            throw new IndexOutOfBoundsException();
        }
    }
}

