/* FichothequeLib_API - Copyright (c) 2010-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.mapeadores.util.logging;

import net.mapeadores.util.localisation.Message;


/**
 *
 * @author Vincent Calame
 */
public interface LineMessageHandler {

    public void addMessage(LineMessage lineMessage);

    public default void addMessage(String category, int lineNumber, Message message) {
        addMessage(LogUtils.toLineMessage(category, lineNumber, message));
    }

    public default void addMessage(String category, int lineNumber, String messageKey, Object... messageValues) {
        addMessage(LogUtils.toLineMessage(category, lineNumber, messageKey, messageValues));
    }

    public default void addMessage(LineMessageException lme) {
        addMessage(lme.getLineMessage());
    }

}
