/* FichothequeLib_Tools - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers.thesaurus;

import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.MergeThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.MoveThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.RemoveThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.ThesaurusImportBuilder;


/**
 *
 * @author Vincent Calame
 */
public abstract class ThesaurusRowParser {

    public final static String CREATION_PARSETYPE = "creation";
    public final static String CHANGE_PARSETYPE = "change";
    public final static String REMOVE_PARSETYPE = "remove";
    public final static String MERGE_PARSETYPE = "merge";
    public final static String MOVE_PARSETYPE = "move";

    public abstract void parseRow(int rowNumber, Row row);

    public abstract ThesaurusImportBuilder getThesaurusImportBuilder();

    public static ThesaurusRowParser newInstance(String[] fieldArray, String parseType, Thesaurus thesaurus, Thesaurus destinationThesaurus, ParseResultBuilder parseResultBuilder, ImportationParseContext parseContext) {
        switch (parseType) {
            case CHANGE_PARSETYPE:
                return ChangeRowParser.newInstance(fieldArray, new EditThesaurusImportBuilder(thesaurus), parseResultBuilder, parseContext);
            case CREATION_PARSETYPE:
                return CreationRowParser.newInstance(fieldArray, new EditThesaurusImportBuilder(thesaurus), parseResultBuilder, parseContext);
            case REMOVE_PARSETYPE:
                return RemoveRowParser.newInstance(fieldArray, new RemoveThesaurusImportBuilder(thesaurus), parseResultBuilder);
            case MOVE_PARSETYPE:
                return MoveRowParser.newInstance(fieldArray, new MoveThesaurusImportBuilder(thesaurus, destinationThesaurus), parseResultBuilder);
            case MERGE_PARSETYPE:
                return MergeRowParser.newInstance(fieldArray, new MergeThesaurusImportBuilder(thesaurus, destinationThesaurus), parseResultBuilder);
            default:
                throw new IllegalStateException("Unknown parse type: " + parseType);
        }
    }

    public static String checkParseType(String parseType) {
        switch (parseType) {
            case CREATION_PARSETYPE:
                return CREATION_PARSETYPE;
            case CHANGE_PARSETYPE:
                return CHANGE_PARSETYPE;
            case REMOVE_PARSETYPE:
                return REMOVE_PARSETYPE;
            case MERGE_PARSETYPE:
                return MERGE_PARSETYPE;
            case MOVE_PARSETYPE:
                return MOVE_PARSETYPE;
            default:
                throw new IllegalArgumentException("Unknown type: " + parseType);
        }
    }

}
