/* FichothequeLib_Tools - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers.thesaurus;

import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.thesaurus.MoveThesaurusImportBuilder;


/**
 *
 * @author Vincent Calame
 */
class MoveRowParser extends ThesaurusRowParser {

    private final int fieldIndex;
    private final boolean isIdalpha;
    private final MoveThesaurusImportBuilder moveThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;

    private MoveRowParser(MoveThesaurusImportBuilder moveThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, int fieldIndex, boolean isIdalpha) {
        this.moveThesaurusImportBuilder = moveThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.fieldIndex = fieldIndex;
        this.isIdalpha = isIdalpha;
    }

    @Override
    public MoveThesaurusImportBuilder getThesaurusImportBuilder() {
        return moveThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        if (row.getColumnCount() <= fieldIndex) {
            parseResultBuilder.missingIdColumn(rowNumber);
            return;

        }
        String idString = row.getColumnValue(fieldIndex).trim();
        Thesaurus thesaurus = moveThesaurusImportBuilder.getThesaurus();
        Motcle motcle = null;
        if (isIdalpha) {
            motcle = thesaurus.getMotcleByIdalpha(idString);
            if (motcle == null) {
                parseResultBuilder.unknownIdalpha(rowNumber, idString);
            }
        } else {
            try {
                int id = Integer.parseInt(idString);
                motcle = thesaurus.getMotcleById(id);
                if (motcle == null) {
                    parseResultBuilder.unknownId(rowNumber, idString);
                }
            } catch (NumberFormatException nfe) {
                parseResultBuilder.notIntegerId(rowNumber, idString);
            }
        }
        if (motcle != null) {
            moveThesaurusImportBuilder.add(motcle);
        }
    }

    static MoveRowParser newInstance(String[] fieldArray, MoveThesaurusImportBuilder moveThesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        int fieldIndex = -1;
        int idalphaIndex = -1;
        int length = fieldArray.length;
        for (int i = 0; i < length; i++) {
            String field = fieldArray[i].trim();
            ThesaurusFieldKey thesaurusFieldKey;
            try {
                thesaurusFieldKey = ThesaurusFieldKey.parse(field);
            } catch (ParseException pe) {
                continue;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
                if (fieldIndex == -1) {
                    fieldIndex = i;
                }
            } else if (thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA)) {
                if (idalphaIndex == -1) {
                    idalphaIndex = i;
                }
            }
        }
        boolean isIdalpha = false;
        if (fieldIndex == -1) {
            if (moveThesaurusImportBuilder.getThesaurus().isIdalphaType()) {
                if (idalphaIndex != -1) {
                    fieldIndex = idalphaIndex;
                    isIdalpha = true;
                } else {
                    parseResultBuilder.missingColumns(ThesaurusFieldKey.ID.toString(), ThesaurusFieldKey.IDALPHA.toString());
                }
            } else {
                parseResultBuilder.missingColumn(ThesaurusFieldKey.ID.toString());
            }
        }
        if (fieldIndex != -1) {
            return new MoveRowParser(moveThesaurusImportBuilder, parseResultBuilder, fieldIndex, isIdalpha);
        } else {
            return null;
        }
    }

}
