/* FichothequeLib_Tools - Copyright (c) 2013-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.importation.parsers.corpus;

import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.parsers.FicheParser;


/**
 *
 * @author Vincent Calame
 */
class ChangeRowParser extends EditRowParser {


    ChangeRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, CorpusColumns corpusColumns, ImportationParseContext parseContext) {
        super(editCorpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        int idIndex = corpusColumns.getIdIndex();
        if (row.getColumnCount() <= idIndex) {
            parseResultBuilder.missingIdColumn(rowNumber);
            return;
        }
        String idString = row.getColumnValue(idIndex).trim();
        FicheMeta ficheMeta = null;
        try {
            int id = Integer.parseInt(idString);
            ficheMeta = corpus.getFicheMetaById(id);
            if (ficheMeta == null) {
                parseResultBuilder.unknownId(rowNumber, idString);
            }
        } catch (NumberFormatException nfe) {
            parseResultBuilder.notIntegerId(rowNumber, idString);
        }
        if (ficheMeta == null) {
            return;
        }
        EditFicheImportBuilder ficheImportBuilder = editCorpusImportBuilder.getEditFicheImportBuilder(ficheMeta);
        populate(ficheImportBuilder, row);
        setCreationDate(ficheImportBuilder, rowNumber, row);
    }

    static ChangeRowParser newInstance(String[] fieldArray, EditCorpusImportBuilder corpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, ImportationParseContext parseContext) {
        CorpusColumns corpusColumns = CorpusColumns.parse(fieldArray, corpusImportBuilder, parseResultBuilder);
        if (corpusColumns.getIdIndex() == -1) {
            parseResultBuilder.missingColumn(FieldKey.SPECIAL_ID);
            return null;
        } else {
            return new ChangeRowParser(corpusImportBuilder, parseResultBuilder, ficheParser, corpusColumns, parseContext);
        }
    }

}
