/* FichothequeLib_Tools - Copyright (c) 2008-2022 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package net.fichotheque.tools.conversion.fieldtofield;

import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.fichotheque.corpus.fiche.Info;


/**
 *
 * @author Vincent Calame
 */
class InfoToFicheItemField extends FieldToFieldConverter {

    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    InfoToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        Info source = fiche.getInfo(sourceKey);
        if ((source == null) || (source.isEmpty())) {
            return;
        }
        if (destinationKey.isProp()) {
            FicheItem ficheItem = source.get(0);
            fiche.setProp(destinationKey, ficheItem);
            if (source.size() > 1) {
                addWarning("_ warning.conversion.manyficheitems", sourceKey.getKeyString());
            }
        } else {
            fiche.appendInfo(destinationKey, source);
        }
        if (removeOldField) {
            fiche.setInfo(sourceKey, null);
        }
    }

}
