/* BdfServer_DirectoryStorage - Copyright (c) 2022-2025 Vincent Calame - Exemole
 * Logiciel libre donné sous triple licence :
 * 1) selon les termes de la CeCILL V2
 * 2) selon les termes de l’EUPL V.1.1
 * 3) selon les termes de la GNU GPLv3
 * Voir le fichier licences.txt
 */


package fr.exemole.bdfserver.storage.directory;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.File;
import net.mapeadores.util.annotation.Nullable;


/**
 *
 * @author Vincent Calame
 */
public interface StorageDirectory {

    public File getDataDir();

    @Nullable
    public File getBackupDir();

    public default boolean isWithBackup() {
        return (getBackupDir() != null);
    }

    public default File getDataFile(String path) {
        return new File(getDataDir(), path);
    }

    public default File getDataDir(String path) {
        File dir = new File(getDataDir(), path);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new BdfStorageException(dir.getPath() + " is not a directory");
            }
        }
        return dir;
    }

    public default StorageFile getStorageFile(String path) {
        File file = new File(getDataDir(), path);
        File backupFile = null;
        if (isWithBackup()) {
            backupFile = new File(getBackupDir(), path);
        }
        return new StorageFile(path, file, backupFile);
    }

}
