/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import net.mapeadores.util.xml.DefaultXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.ns.NameSpace;

public class XsltWriter
extends DefaultXMLWriter {
    public XsltWriter() {
        this.setAposEscaped(false);
    }

    public void startXslStyleSheetOpenTag() throws IOException {
        this.startOpenTag("xsl:stylesheet");
        XMLUtils.appendNameSpaceAttribute(this, NameSpace.XSL_NAMESPACE);
        this.addAttribute("version", "1.0");
    }

    public void openXslStyleSheet() throws IOException {
        this.startXslStyleSheetOpenTag();
        this.endOpenTag();
    }

    public void closeXslStyleSheet() throws IOException {
        this.closeTag("xsl:stylesheet");
    }

    public void addDecimalFormat(DecimalFormatSymbols symbols, String name) throws IOException {
        this.startOpenTag("xsl:decimal-format");
        this.addAttribute("decimal-separator", symbols.getDecimalSeparator());
        char carac = symbols.getGroupingSeparator();
        if (carac == ' ') {
            carac = '\u00a0';
        }
        this.addAttribute("grouping-separator", carac);
        this.addAttribute("pattern-separator", symbols.getPatternSeparator());
        this.addNameAttribute(name);
        this.closeEmptyTag();
    }

    public void addLiteralVariable(String name, String value) throws IOException {
        this.startOpenTag("xsl:variable");
        this.addNameAttribute(name);
        if (value != null) {
            this.addSelectAttribute("'" + value + "'");
        }
        this.closeEmptyTag();
    }

    public void addXslVariable(String name, String select, boolean isString) throws IOException {
        this.startOpenTag("xsl:variable");
        this.addNameAttribute(name);
        if (isString) {
            if (select != null) {
                this.addSelectAttribute("'" + select + "'");
            }
        } else {
            this.addSelectAttribute(select);
        }
        this.closeEmptyTag();
    }

    public void addXslParam(String name) throws IOException {
        this.startOpenTag("xsl:param");
        this.addNameAttribute(name);
        this.closeEmptyTag();
    }

    public void addXslParam(String name, String select, boolean isString) throws IOException {
        this.startOpenTag("xsl:param");
        this.addNameAttribute(name);
        if (isString) {
            if (select != null) {
                this.addSelectAttribute("'" + select + "'");
            }
        } else {
            this.addSelectAttribute(select);
        }
        this.closeEmptyTag();
    }

    public void addXslImport(String href) throws IOException {
        this.startOpenTag("xsl:import");
        this.addAttribute("href", href);
        this.closeEmptyTag();
    }

    public void addXslInclude(String href) throws IOException {
        this.startOpenTag("xsl:include");
        this.addAttribute("href", href);
        this.closeEmptyTag();
    }

    public void addHtmlStrictXslOutput() throws IOException {
        this.startOpenTag("xsl:output");
        this.addAttribute("method", "html");
        this.addAttribute("encoding", "UTF-8");
        this.addAttribute("doctype-public", "-//W3C//DTD HTML 4.01//EN");
        this.addAttribute("doctype-system", "http://www.w3.org/TR/html4/strict.dtd");
        this.closeEmptyTag();
    }

    public void openMatchXslTemplate(String match, String mode) throws IOException {
        this.addSeparator();
        this.startOpenTag("xsl:template");
        this.addMatchAttribute(match);
        this.addModeAttribute(mode);
        this.endOpenTag();
    }

    public void openMatchXslTemplate(String match, String mode, String priority) throws IOException {
        this.addSeparator();
        this.startOpenTag("xsl:template");
        this.addMatchAttribute(match);
        this.addModeAttribute(mode);
        this.addPriorityAttribute(priority);
        this.endOpenTag();
    }

    public void openNameXslTemplate(String name) throws IOException {
        this.addSeparator();
        this.startOpenTag("xsl:template");
        this.addNameAttribute(name);
        this.endOpenTag();
    }

    public void openNameXslTemplate(String name, String mode) throws IOException {
        this.addSeparator();
        this.startOpenTag("xsl:template");
        this.addNameAttribute(name);
        this.addModeAttribute(mode);
        this.endOpenTag();
    }

    public void openNameXslTemplate(String name, String mode, String priority) throws IOException {
        this.addSeparator();
        this.startOpenTag("xsl:template");
        this.addNameAttribute(name);
        this.addModeAttribute(mode);
        this.addPriorityAttribute(priority);
        this.endOpenTag();
    }

    public void openXslForEach(String select) throws IOException {
        this.startOpenTag("xsl:for-each");
        this.addAttribute("select", select);
        this.endOpenTag();
    }

    public void openXslIf(String test) throws IOException {
        this.startOpenTag("xsl:if", false);
        this.addAttribute("test", test);
        this.endOpenTag();
    }

    public void openXslIf(String test, boolean withIndent) throws IOException {
        this.startOpenTag("xsl:if", withIndent);
        this.addAttribute("test", test);
        this.endOpenTag();
    }

    public void openXslWhen(String test) throws IOException {
        this.startOpenTag("xsl:when");
        this.addAttribute("test", test);
        this.endOpenTag();
    }

    public void openXslChoose() throws IOException {
        this.openTag("xsl:choose", false);
    }

    public void openXslOtherwise() throws IOException {
        this.startOpenTag("xsl:otherwise");
        this.endOpenTag();
    }

    public void closeXslTemplate() throws IOException {
        this.closeTag("xsl:template");
    }

    public void closeXslForEach() throws IOException {
        this.closeTag("xsl:for-each");
    }

    public void closeXslIf() throws IOException {
        this.closeTag("xsl:if", false);
    }

    public void closeXslIf(boolean withIndent) throws IOException {
        this.closeTag("xsl:if", withIndent);
    }

    public void closeXslOtherwise() throws IOException {
        this.closeTag("xsl:otherwise", false);
    }

    public void closeXslChoose() throws IOException {
        this.closeTag("xsl:choose");
    }

    public void closeXslWhen() throws IOException {
        this.closeTag("xsl:when", false);
    }

    public void openXslApplyTemplates(String select, String mode, boolean indent) throws IOException {
        this.startOpenTag("xsl:apply-templates", indent);
        this.addSelectAttribute(select);
        this.addModeAttribute(mode);
        this.endOpenTag();
    }

    public void closeXslApplyTemplates(boolean indent) throws IOException {
        this.closeTag("xsl:apply-templates", indent);
    }

    public void addXslApplyTemplates(String select) throws IOException {
        this.addXslApplyTemplates(select, null);
    }

    public void addXslApplyTemplates(String select, String mode) throws IOException {
        this.startOpenTag("xsl:apply-templates", false);
        this.addSelectAttribute(select);
        this.addModeAttribute(mode);
        this.closeEmptyTag();
    }

    public void addXslApplyTemplates(String select, String mode, boolean indentBefore) throws IOException {
        this.startOpenTag("xsl:apply-templates", indentBefore);
        this.addSelectAttribute(select);
        this.addModeAttribute(mode);
        this.closeEmptyTag();
    }

    public void addXslCallTemplate(String name, String mode) throws IOException {
        this.startOpenTag("xsl:call-template", false);
        this.addNameAttribute(name);
        this.addModeAttribute(mode);
        this.closeEmptyTag();
    }

    public void openXslCallTemplate(String name, boolean indent) throws IOException {
        this.startOpenTag("xsl:call-template", indent);
        this.addNameAttribute(name);
        this.endOpenTag();
    }

    public void closeXslCallTemplate(boolean indent) throws IOException {
        this.closeTag("xsl:call-template", indent);
    }

    public void addXslWithParam(String name, String select, boolean isString) throws IOException {
        this.startOpenTag("xsl:with-param");
        this.addNameAttribute(name);
        if (isString) {
            if (select != null) {
                this.addSelectAttribute("'" + select + "'");
            }
        } else {
            this.addSelectAttribute(select);
        }
        this.closeEmptyTag();
    }

    public void addXslValueOf(String select) throws IOException {
        this.startOpenTag("xsl:value-of", false);
        this.addSelectAttribute(select);
        this.closeEmptyTag();
    }

    public void addXslValueOf(String select, boolean disableOutputEscaping) throws IOException {
        this.startOpenTag("xsl:value-of", false);
        this.addSelectAttribute(select);
        this.addAttribute("disable-output-escaping", disableOutputEscaping ? "yes" : "no");
        this.closeEmptyTag();
    }

    public void addXslValueOf(String select, boolean disableOutputEscaping, boolean indentBefore) throws IOException {
        this.startOpenTag("xsl:value-of", indentBefore);
        this.addSelectAttribute(select);
        this.addAttribute("disable-output-escaping", disableOutputEscaping ? "yes" : "no");
        this.closeEmptyTag();
    }

    public void addXslText(String text) throws IOException {
        this.openTag("xsl:text", false);
        this.addText(text);
        this.closeTag("xsl:text", false);
    }

    public void addXslText(String text, boolean disableOutputEscaping) throws IOException {
        this.startOpenTag("xsl:text", false);
        this.addAttribute("disable-output-escaping", disableOutputEscaping ? "yes" : "no");
        this.endOpenTag();
        this.addText(text);
        this.closeTag("xsl:text", false);
    }

    public void addSpaceXslText() throws IOException {
        this.addNoEscapeXslText(" ");
    }

    public void addTabXslText() throws IOException {
        this.addNoEscapeXslText("&#x9;");
    }

    public void addNewlineXslText() throws IOException {
        this.addNoEscapeXslText("&#xA;");
    }

    private void addNoEscapeXslText(String text) throws IOException {
        this.openTag("xsl:text", false);
        this.append(text);
        this.closeTag("xsl:text", false);
    }

    public void addSeparator() throws IOException {
        this.append("\n");
    }

    public void addSelectAttribute(String select) throws IOException {
        this.addAttribute("select", select);
    }

    public void addNameAttribute(String name) throws IOException {
        this.addAttribute("name", name);
    }

    public void addModeAttribute(String mode) throws IOException {
        this.addAttribute("mode", mode);
    }

    public void addMatchAttribute(String match) throws IOException {
        this.addAttribute("match", match);
    }

    public void addPriorityAttribute(String priority) throws IOException {
        this.addAttribute("priority", priority);
    }

    private void addAttribute(String attributeName, char c) throws IOException {
        char[] array = new char[]{c};
        this.addAttribute(attributeName, new String(array));
    }
}

