/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.collation;

import java.io.Serializable;
import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import net.mapeadores.util.text.SubstringPosition;

public final class CollationUnit
implements Serializable {
    private final String sourceString;
    private final String collatedString;
    private final int[] correspondances;

    public CollationUnit(String sourceString, RuleBasedCollator collator) {
        this.sourceString = sourceString;
        CollationElementIterator collationElementIterator = collator.getCollationElementIterator(sourceString);
        StringBuilder buf = new StringBuilder();
        ArrayList<Integer> correspondancesList = new ArrayList<Integer>();
        boolean onSpaceChar = false;
        while (true) {
            int order = collationElementIterator.next();
            int offset = collationElementIterator.getOffset() - 1;
            if (order == -1) break;
            int primary = CollationElementIterator.primaryOrder(order);
            char c = sourceString.charAt(offset);
            if (primary > 0) {
                if (CollationUnit.assimilateToSpace(c)) {
                    if (onSpaceChar) continue;
                    buf.append('\u0000');
                    correspondancesList.add(offset);
                    onSpaceChar = true;
                    continue;
                }
                buf.append((char)primary);
                correspondancesList.add(offset);
                onSpaceChar = false;
                continue;
            }
            if (primary != 0 || onSpaceChar || !Character.isSpaceChar(c)) continue;
            buf.append('\u0000');
            correspondancesList.add(offset);
            onSpaceChar = true;
        }
        this.collatedString = buf.toString();
        int size = correspondancesList.size();
        this.correspondances = new int[size];
        for (int i = 0; i < size; ++i) {
            this.correspondances[i] = (Integer)correspondancesList.get(i);
        }
    }

    public String getSourceString() {
        return this.sourceString;
    }

    public String getCollatedString() {
        return this.collatedString;
    }

    public int length() {
        return this.collatedString.length();
    }

    public String toString() {
        return this.collatedString;
    }

    public int sourceIndexOf(int collatedIndex) {
        return this.correspondances[collatedIndex];
    }

    public SubstringPosition getSubstringPositionInSourceString(SubstringPosition positionInCollatedString) {
        int startIndex = this.sourceIndexOf(positionInCollatedString.getBeginIndex());
        int endIndex = this.sourceIndexOf(positionInCollatedString.getEndIndex());
        return new SubstringPosition(startIndex, endIndex - startIndex + 1);
    }

    public static String collate(String sourceString, RuleBasedCollator collator) {
        return CollationUnit.collate(sourceString, collator, false);
    }

    public static String collate(String sourceString, RuleBasedCollator collator, boolean ignoreNonLetter) {
        if (sourceString == null || sourceString.length() == 0) {
            return "";
        }
        CollationElementIterator collationElementIterator = collator.getCollationElementIterator(sourceString);
        StringBuilder buf = new StringBuilder();
        boolean onSpaceChar = false;
        while (true) {
            int order = collationElementIterator.next();
            int offset = collationElementIterator.getOffset() - 1;
            if (order == -1) break;
            int primary = CollationElementIterator.primaryOrder(order);
            char c = sourceString.charAt(offset);
            if (primary > 0) {
                if (CollationUnit.assimilateToSpace(c)) {
                    if (ignoreNonLetter || onSpaceChar) continue;
                    buf.append('\u0000');
                    onSpaceChar = true;
                    continue;
                }
                buf.append((char)primary);
                onSpaceChar = false;
                continue;
            }
            if (primary != 0 || ignoreNonLetter || onSpaceChar || !Character.isSpaceChar(c)) continue;
            buf.append('\u0000');
            onSpaceChar = true;
        }
        return buf.toString();
    }

    public static boolean checkReplace(String oldSourceString, String newSourceString) {
        int oldLength;
        boolean replace = false;
        int newLength = newSourceString.length();
        if (newLength < (oldLength = oldSourceString.length())) {
            replace = true;
        } else if (newLength == oldLength && newSourceString.compareTo(oldSourceString) > 0) {
            replace = true;
        }
        return replace;
    }

    private static boolean assimilateToSpace(char carac) {
        switch (Character.getType(carac)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

