/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LogUtils;

public final class HtmlPrinterUtils {
    private HtmlPrinterUtils() {
    }

    public static boolean printCommandMessage(HtmlPrinter hp, @Nullable CommandMessage commandMessage, String doneClasses, String errorClasses) {
        if (commandMessage == null) {
            return false;
        }
        HtmlAttributes spanAttr = commandMessage.isErrorMessage() ? HA.classes(errorClasses) : HA.classes(doneClasses);
        HtmlPrinterUtils.printCommandMessage(hp, commandMessage, spanAttr);
        return true;
    }

    public static boolean printCommandMessage(HtmlPrinter hp, @Nullable CommandMessage commandMessage, HtmlAttributes doneAttributes, HtmlAttributes errorAttributes) {
        if (commandMessage == null) {
            return false;
        }
        HtmlAttributes spanAttr = doneAttributes;
        if (commandMessage.isErrorMessage()) {
            spanAttr = errorAttributes;
        }
        HtmlPrinterUtils.printCommandMessage(hp, commandMessage, spanAttr);
        return true;
    }

    private static boolean printCommandMessage(HtmlPrinter hp, CommandMessage commandMessage, HtmlAttributes attributes) {
        hp.P().SPAN(attributes).__localize(commandMessage)._SPAN();
        if (commandMessage.hasMultiError()) {
            hp.SPAN(attributes).SMALL();
            for (Message message : commandMessage.getMultiErrorList()) {
                HtmlPrinterUtils.printSubMessage(hp, message);
            }
            hp._SMALL()._SPAN();
        }
        hp._P();
        if (commandMessage.hasCommandLogs()) {
            LogUtils.printHtml(hp, commandMessage.getCommandLogs(), "global-Logs");
        }
        return true;
    }

    private static boolean printSubMessage(HtmlPrinter hp, Message message) {
        hp.BR();
        if (message instanceof LineMessage) {
            hp.__append(((LineMessage)message).getLineNumber()).__escape(": ");
        }
        hp.__localize(message);
        return true;
    }
}

