/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.util.List;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.def.TagNameInfo;
import net.fichotheque.extraction.def.ThesaurusExtractDef;
import net.fichotheque.extraction.filterunit.FilterUnit;
import net.fichotheque.extraction.run.MotcleExtractInfo;
import net.fichotheque.extraction.run.ThesaurusExtractResult;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.xml.extraction.ExtractionXMLUtils;
import net.fichotheque.xml.extraction.MotcleXMLPart;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class ThesaurusExtractXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final int extractVersion;
    private final MotcleXMLPart motcleXMLPart;
    private final TagNames tagNames;

    public ThesaurusExtractXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractVersion = extractParameters.getExtractVersion();
        this.motcleXMLPart = new MotcleXMLPart(xmlWriter, extractParameters);
        this.tagNames = new TagNames(this.extractVersion);
    }

    public void addThesaurusExtract(ThesaurusExtractResult thesaurusExtractResult) throws IOException {
        this.addThesaurusExtract(thesaurusExtractResult, null);
    }

    public void addThesaurusExtract(ThesaurusExtractResult thesaurusExtractResult, FilterUnit filterUnit) throws IOException {
        ThesaurusExtractDef thesaurusExtractDef = thesaurusExtractResult.getThesaurusExtractDef();
        List<ThesaurusExtractResult.Entry> entryList = thesaurusExtractResult.getEntryList();
        if (entryList.isEmpty() && this.extractParameters.hideIfEmpty(filterUnit)) {
            return;
        }
        String tagName = this.getTagName(thesaurusExtractDef.getTagNameInfo());
        boolean withTag = tagName != null;
        String name = thesaurusExtractDef.getName();
        if (name != null) {
            if (withTag) {
                this.startOpenTag(tagName);
                this.addAttribute("name", name);
                if (this.extractVersion == 1) {
                    this.addAttribute("extrait-name", name);
                }
                ExtractionXMLUtils.addFilterParameters((XMLWriter)this, filterUnit);
                this.endOpenTag();
            }
            for (ThesaurusExtractResult.Entry entry : entryList) {
                for (MotcleExtractInfo motcleExtractInfo : entry.getMotcleExtractInfoList()) {
                    this.motcleXMLPart.addMotcle(motcleExtractInfo);
                }
            }
            if (withTag) {
                this.closeTag(tagName);
            }
        } else {
            boolean withThesaurusTitle = thesaurusExtractDef.isWithThesaurusTitle();
            LangContext langContext = this.extractParameters.getExtractionContext().getLangContext();
            for (ThesaurusExtractResult.Entry entry : entryList) {
                Thesaurus thesaurus = entry.getThesaurus();
                if (withTag) {
                    this.startOpenTag(tagName);
                    this.addAttribute("thesaurus", thesaurus.getSubsetName());
                    ExtractionXMLUtils.addFilterParameters((XMLWriter)this, filterUnit);
                    this.endOpenTag();
                }
                for (MotcleExtractInfo motcleExtractInfo : entry.getMotcleExtractInfoList()) {
                    this.motcleXMLPart.addMotcle(motcleExtractInfo);
                }
                if (withThesaurusTitle) {
                    String titleTagName = this.tagNames.getSubsetTitleTagName();
                    this.openTag(titleTagName);
                    if (langContext instanceof ListLangContext) {
                        for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                            Lang lang = unit.getLang();
                            String title = FichothequeUtils.getTitle(thesaurus, lang);
                            LabelUtils.addLabel(this, lang, title);
                        }
                    } else if (langContext instanceof UserLangContext) {
                        UserLangContext userLangContext = (UserLangContext)langContext;
                        Lang workingLang = userLangContext.getWorkingLang();
                        String title = FichothequeUtils.getTitle(thesaurus, workingLang);
                        LabelUtils.addLabel(this, null, title);
                    }
                    this.closeTag(titleTagName);
                }
                if (!withTag) continue;
                this.closeTag(tagName);
            }
        }
    }

    private String getTagName(TagNameInfo tagNameInfo) {
        switch (tagNameInfo.getType()) {
            case 3: {
                return tagNameInfo.getCustomTagName();
            }
            case 2: {
                return null;
            }
        }
        return this.tagNames.getSubsetTagName((short)2);
    }
}

