/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.permission;

import java.util.function.Predicate;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.PermissionUtils;
import net.mapeadores.util.exceptions.SwitchException;

public class PermissionPredicate
implements Predicate<SubsetItem> {
    private final PermissionSummary permissionSummary;
    private final boolean read;

    private PermissionPredicate(PermissionSummary permissionSummary, boolean read) {
        this.permissionSummary = permissionSummary;
        this.read = read;
    }

    @Override
    public boolean test(SubsetItem subsetItem) {
        if (subsetItem instanceof FicheMeta) {
            if (this.read) {
                return this.permissionSummary.canRead((FicheMeta)subsetItem);
            }
            return this.permissionSummary.canWrite((FicheMeta)subsetItem);
        }
        int level = this.read ? this.permissionSummary.getReadLevel(subsetItem.getSubsetKey()) : this.permissionSummary.getWriteLevel(subsetItem.getSubsetKey());
        switch (level) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                throw new IllegalStateException("Level only available for corpus: " + level);
            }
            case 3: {
                return PermissionUtils.junctionTest(subsetItem, this.permissionSummary, this.read);
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        throw new SwitchException("Unknown level: " + level);
    }

    public static PermissionPredicate read(PermissionSummary permissionSummary) {
        return new PermissionPredicate(permissionSummary, true);
    }

    public static PermissionPredicate write(PermissionSummary permissionSummary) {
        return new PermissionPredicate(permissionSummary, false);
    }
}

