/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.span;

import java.net.URI;
import java.net.URISyntaxException;
import net.fichotheque.corpus.fiche.S;
import net.fichotheque.tools.parsers.span.SpanParseResult;
import net.fichotheque.tools.parsers.span.SpanParser;

class WwwParser
extends SpanParser {
    WwwParser() {
    }

    @Override
    public char getStartChar() {
        return 'w';
    }

    @Override
    public SpanParseResult parse(String bout, int startIndex) {
        String value;
        int length = bout.length();
        if (startIndex > length - 6) {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (bout.charAt(startIndex + 1) != 'w') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (bout.charAt(startIndex + 2) != 'w') {
            return SpanParseResult.IGNORE_RESULT_2;
        }
        if (bout.charAt(startIndex + 3) != '.') {
            return SpanParseResult.IGNORE_RESULT_3;
        }
        char prems = bout.charAt(startIndex + 4);
        if (!WwwParser.checkCharInUrl(prems)) {
            return SpanParseResult.IGNORE_RESULT_3;
        }
        StringBuilder refBuffer = new StringBuilder();
        refBuffer.append("http://www.");
        refBuffer.append(prems);
        int stopIndex = WwwParser.appendUrl(bout, refBuffer, startIndex + 5);
        S span = new S(3);
        String ref = refBuffer.toString();
        span.setRef(ref);
        try {
            URI uri = new URI(ref);
            value = uri.getHost() + uri.getPath();
        }
        catch (URISyntaxException use) {
            value = ref.substring(7);
        }
        span.setValue(value);
        return new SpanParseResult(span, stopIndex);
    }
}

