/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.tokenizers.subfield;

import net.fichotheque.corpus.SubfieldValue;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.Tokenizer;
import net.fichotheque.format.Tokens;
import net.fichotheque.format.formatters.SubfieldFormatter;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.models.PersonCore;

class PersonPropTokenizer
implements Tokenizer {
    private final SubfieldKey subfieldKey;
    private final SubfieldFormatter subfieldFormatter;

    PersonPropTokenizer(SubfieldKey subfieldKey, SubfieldFormatter subfieldFormatter) {
        this.subfieldKey = subfieldKey;
        this.subfieldFormatter = subfieldFormatter;
    }

    @Override
    public Tokens tokenize(FormatSource formatSource) {
        FicheItem ficheItem = (FicheItem)((FichePointeur)formatSource.getSubsetItemPointeur()).getValue(this.subfieldKey);
        if (ficheItem == null) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        if (!(ficheItem instanceof PersonItem)) {
            return FormatterUtils.EMPTY_TOKENS;
        }
        PersonCore personCore = formatSource.getFichothequeQuestioner().toPersonCore((PersonItem)ficheItem);
        String subfieldString = this.getSubfieldString(personCore);
        if (subfieldString != null) {
            SubfieldValue subfieldValue = FormatterUtils.toSubfieldValue(subfieldString);
            String value = this.subfieldFormatter.formatSubfield(subfieldValue, formatSource);
            return FormatterUtils.toTokens(value);
        }
        return FormatterUtils.EMPTY_TOKENS;
    }

    private String getSubfieldString(PersonCore personCore) {
        switch (this.subfieldKey.getSubtype()) {
            case "surname": {
                return personCore.getSurname();
            }
            case "forename": {
                return personCore.getForename();
            }
            case "nonlatin": {
                return personCore.getNonlatin();
            }
            case "surnamefirst": {
                boolean surnameFirst = personCore.isSurnameFirst();
                return surnameFirst ? "1" : "0";
            }
        }
        throw new SwitchException("subfieldType = " + this.subfieldKey.getSubtype());
    }
}

