/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheMetaFormatter;
import net.fichotheque.tools.format.JsonParameters;
import net.fichotheque.tools.format.catalogs.FicheMetaFormatterCatalog;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class FicheMetaFormatterParser {
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.build("type", "id");

    private FicheMetaFormatterParser() {
    }

    public static FicheMetaFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter, boolean withCorpusName, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = "{title}";
        }
        try {
            return FicheMetaFormatterParser.parse(pattern, formatContext, withWeightFilter, withCorpusName);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static FicheMetaFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter, boolean withCorpusName) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, withWeightFilter, withCorpusName), pattern);
        return new InternalFicheMetaFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withWeightFilter;
        private final boolean withCorpusName;

        private InternalInstructionResolver(FormatContext formatContext, boolean withWeightFilter, boolean withCorpusName) {
            this.provider = formatContext.getInstructionResolverProvider();
            this.withWeightFilter = withWeightFilter;
            this.withCorpusName = withCorpusName;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(FicheMetaFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "corpus": {
                    return FicheMetaFormatterCatalog.CORPUS;
                }
                case "formsyntax": {
                    return new FicheMetaFormatterCatalog.FormSyntax(this.withWeightFilter, this.withCorpusName);
                }
                case "id": 
                case "idcorpus": {
                    return FicheMetaFormatterCatalog.ID;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction, DEFAULT_JSONPARAMETERS);
                    return new FicheMetaFormatterCatalog.Json(jsonParameters);
                }
                case "lang": {
                    return FicheMetaFormatterCatalog.LANG;
                }
                case "weight": 
                case "poids": {
                    return FicheMetaFormatterCatalog.WEIGHT;
                }
                case "title": 
                case "titre": {
                    return FicheMetaFormatterCatalog.TITLE;
                }
            }
            return null;
        }
    }

    private static class InternalFicheMetaFormatter
    implements FicheMetaFormatter {
        private final Object[] partArray;

        private InternalFicheMetaFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatFicheMeta(FicheMeta ficheMeta, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                FicheMetaFormatter formatter = (FicheMetaFormatter)obj;
                buf.append(formatter.formatFicheMeta(ficheMeta, weight, formatSource));
            }
            return buf.toString();
        }
    }
}

