/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.catalogs;

import java.io.IOException;
import java.util.List;
import net.fichotheque.addenda.Document;
import net.fichotheque.addenda.Version;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.DocumentFormatter;
import net.fichotheque.json.DocumentJson;
import net.fichotheque.tools.format.JsonParameters;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.LangContext;

public final class DocumentFormatterCatalog {
    public static final DocumentFormatter ADDENDA = (document, weight, formatSource) -> document.getSubsetName();
    public static final DocumentFormatter BASENAME = (document, weight, formatSource) -> document.getBasename();
    public static final DocumentFormatter EXTENSIONS = (document, weight, formatSource) -> {
        List<Version> versionList = document.getVersionList();
        if (versionList.size() == 1) {
            return '.' + versionList.get(0).getExtension();
        }
        StringBuilder buf = new StringBuilder();
        for (Version version : versionList) {
            buf.append('[');
            buf.append('.');
            buf.append(version.getExtension());
            buf.append(']');
        }
        return buf.toString();
    };
    public static final DocumentFormatter ID = (document, weight, formatSource) -> String.valueOf(document.getId());
    public static final DocumentFormatter WEIGHT = (document, weight, formatSource) -> String.valueOf(weight);
    public static final DocumentFormatter WITHWEIGHTFILTER_FORMSYNTAX = new InternalFormSyntax(true);
    public static final DocumentFormatter WITHOUTWEIGHTFILTER_FORMSYNTAX = new InternalFormSyntax(false);

    private DocumentFormatterCatalog() {
    }

    private static class InternalFormSyntax
    implements DocumentFormatter {
        private final boolean withWeightFilter;

        private InternalFormSyntax(boolean withWeightFilter) {
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public String formatDocument(Document document, int weight, FormatSource formatSource) {
            if (this.withWeightFilter || weight == 1) {
                return String.valueOf(document.getId());
            }
            StringBuilder buf = new StringBuilder();
            buf.append(String.valueOf(document.getId()));
            buf.append(" <");
            buf.append(weight);
            buf.append(">");
            return buf.toString();
        }
    }

    public static class Json
    implements DocumentFormatter {
        private final JsonParameters jsonParameters;
        private final LangContext customLangContext;

        public Json(JsonParameters jsonParameters, LangContext customLangContext) {
            this.jsonParameters = jsonParameters;
            this.customLangContext = customLangContext;
        }

        @Override
        public String formatDocument(Document document, int weight, FormatSource formatSource) {
            LangContext langContext = this.customLangContext != null ? this.customLangContext : formatSource.getLangContext();
            StringBuilder buf = new StringBuilder();
            JSONWriter jw = new JSONWriter(buf);
            try {
                jw.object();
                DocumentJson.properties(jw, document, langContext, this.jsonParameters.getPropertyEligibility());
                jw.endObject();
            }
            catch (IOException ioe) {
                throw new ShouldNotOccurException(ioe);
            }
            return buf.toString();
        }
    }
}

