/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.duplication;

import java.util.List;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.Info;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.PurgeEngine;
import net.fichotheque.tools.duplication.DuplicationParameters;
import net.fichotheque.tools.duplication.DuplicationUtils;
import net.fichotheque.tools.duplication.SubsetMatch;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.exceptions.SwitchException;

public class DuplicationEngine {
    private final DuplicationParameters duplicationParameters;
    private final JunctionEditor junctionEditor;
    private final FichothequeEditor fichothequeEditor;
    private Corpus originCorpus;
    private Corpus destinationCorpus;

    private DuplicationEngine(FichothequeEditor fichothequeEditor, DuplicationParameters duplicationParameters) {
        this.fichothequeEditor = fichothequeEditor;
        this.junctionEditor = fichothequeEditor.getJunctionEditor();
        this.duplicationParameters = duplicationParameters;
    }

    public static SubsetMatch run(DuplicationParameters duplicationParameters, FichothequeEditor fichothequeEditor) {
        DuplicationEngine duplicationEngine = new DuplicationEngine(fichothequeEditor, duplicationParameters);
        return duplicationEngine.run();
    }

    private SubsetMatch run() {
        PurgeEngine purgeEngine = this.getPurgeEngine();
        List<DuplicationParameters.FieldMatching> matchingList = this.duplicationParameters.getFieldMatchingList();
        this.originCorpus = this.duplicationParameters.getOriginCorpus();
        this.destinationCorpus = this.duplicationParameters.getDestinationCorpus();
        CorpusEditor destinationEditor = this.fichothequeEditor.getCorpusEditor(this.destinationCorpus);
        SubsetMatch subsetMatch = new SubsetMatch(this.originCorpus, this.destinationCorpus);
        for (DuplicationParameters.Entry entry : this.duplicationParameters.getEntryList()) {
            FicheMeta origin = entry.getOrigin();
            FicheMeta destination = this.createDestination(destinationEditor, entry.getDestinationId());
            Fiche fiche = origin.getCorpus().getFiche(origin);
            if (purgeEngine != null) {
                purgeEngine.purge(fiche);
            }
            if (!matchingList.isEmpty()) {
                this.convertFiche(fiche, matchingList);
            }
            CorpusTools.copy(destinationEditor, origin, destination, fiche);
            subsetMatch.add(origin, destination);
        }
        SubsetEligibility subsetEligibility = this.getSubsetEligibility();
        if (subsetEligibility != null) {
            DuplicationUtils.copyJunctions(this.junctionEditor, subsetMatch, subsetEligibility);
            if (subsetEligibility.accept(this.originCorpus)) {
                DuplicationUtils.replicateLinks(this.junctionEditor, subsetMatch);
            }
        }
        if (this.duplicationParameters.withLinkToOrigin()) {
            DuplicationUtils.linkToOrigin(this.junctionEditor, subsetMatch, this.duplicationParameters.getLinkToOriginMode(), this.duplicationParameters.getLinkToOriginWeight());
        }
        return subsetMatch;
    }

    private FicheMeta createDestination(CorpusEditor destinationEditor, int id) {
        FicheMeta destination = null;
        try {
            destination = destinationEditor.createFiche(id);
        }
        catch (ExistingIdException eie) {
            throw new ShouldNotOccurException("ExistingId test done before");
        }
        catch (NoMasterIdException eie) {
            throw new ShouldNotOccurException("NoMasterId test done before");
        }
        return destination;
    }

    private SubsetEligibility getSubsetEligibility() {
        switch (this.duplicationParameters.getFilterType()) {
            case 2: {
                return null;
            }
            case 3: {
                return this.duplicationParameters.getCustomFilter().getSubsetEligibility();
            }
            case 1: {
                return EligibilityUtils.ALL_SUBSET_ELIGIBILITY;
            }
        }
        throw new SwitchException("Unknown type: " + this.duplicationParameters.getFilterType());
    }

    private PurgeEngine getPurgeEngine() {
        switch (this.duplicationParameters.getFilterType()) {
            case 3: {
                return new PurgeEngine(this.duplicationParameters.getCustomFilter().getFieldPredicate());
            }
        }
        return null;
    }

    private void convertFiche(Fiche fiche, List<DuplicationParameters.FieldMatching> matchingList) {
        for (DuplicationParameters.FieldMatching fieldMatching : matchingList) {
            Section section;
            FieldKey originKey = fieldMatching.getOriginKey();
            FieldKey destinationKey = fieldMatching.getDestinationKey();
            if (originKey.isProp()) {
                Prop prop = fiche.getProp(originKey);
                if (prop == null) continue;
                fiche.setProp(destinationKey, prop.getFicheItem());
                fiche.setProp(originKey, null);
                continue;
            }
            if (originKey.isInfo()) {
                Info info = fiche.getInfo(originKey);
                if (info == null) continue;
                fiche.appendInfo(destinationKey, info);
                fiche.setInfo(originKey, null);
                continue;
            }
            if (!originKey.isSection() || (section = fiche.getSection(originKey)) == null) continue;
            fiche.appendSection(destinationKey, section);
            fiche.setSection(originKey, null);
        }
    }
}

