/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.ConversionUtils;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.utils.FicheUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MultiMessageHandler;

class SimpleToField
extends FieldToFieldConverter {
    private final FieldKey destinationKey;
    private final FieldKey sourceKey;

    SimpleToField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.destinationKey = destinationKey;
        this.sourceKey = sourceKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        FicheItem ficheItem = this.getFicheItem(fiche);
        if (ficheItem == null) {
            return;
        }
        switch (this.destinationKey.getCategory()) {
            case 1: {
                fiche.setProp(this.destinationKey, ficheItem);
                break;
            }
            case 2: {
                fiche.appendInfo(this.destinationKey, FicheUtils.toFicheItems(ficheItem));
                break;
            }
            case 3: {
                fiche.appendSection(this.destinationKey, FicheUtils.toFicheBlocks(ConversionUtils.toFicheBlock(ficheItem)));
            }
        }
        if (removeOldField) {
            switch (this.sourceKey.getKeyString()) {
                case "title": {
                    fiche.setTitle("");
                    break;
                }
                case "subtitle": {
                    fiche.setSubtitle(null);
                }
            }
        }
    }

    private FicheItem getFicheItem(Fiche fiche) {
        switch (this.sourceKey.getKeyString()) {
            case "title": {
                return this.getItem(fiche.getTitle());
            }
            case "subtitle": {
                return fiche.getSubtitle();
            }
            case "lang": {
                Lang lang = fiche.getLang();
                if (lang != null) {
                    return new LanguageItem(lang);
                }
                return null;
            }
        }
        throw new SwitchException("sourceKey = " + this.sourceKey.getKeyString());
    }

    private Item getItem(String s) {
        if (s.length() == 0) {
            return null;
        }
        return new Item(s);
    }
}

