/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.thesaurus;

import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.metadata.ThesaurusMetadata;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;

public interface Thesaurus
extends Subset {
    public List<Motcle> getFirstLevelList();

    public Motcle getMotcleById(int var1);

    public Motcle getMotcleByIdalpha(String var1);

    public Motcle getMotcleByLabel(String var1, Lang var2);

    public List<Motcle> getMotcleList();

    default public ThesaurusMetadata getThesaurusMetadata() {
        return (ThesaurusMetadata)this.getMetadata();
    }

    default public boolean isIdalphaType() {
        return this.getThesaurusMetadata().getThesaurusType().equals("idalpha");
    }

    default public boolean isBabelienType() {
        return this.getThesaurusMetadata().getThesaurusType().equals("babelien");
    }

    default public boolean isMultiType() {
        return this.getThesaurusMetadata().getThesaurusType().equals("multi");
    }

    default public Motcle seekMotcleByLabel(String labelString, Lang preferredLang) {
        Motcle motcle = this.getMotcleByLabel(labelString, preferredLang);
        if (motcle != null) {
            return motcle;
        }
        Lang rootLang = null;
        if (!preferredLang.isRootLang() && (motcle = this.getMotcleByLabel(labelString, rootLang = preferredLang.getRootLang())) != null) {
            return motcle;
        }
        Langs authorizedLangs = this.getThesaurusMetadata().getAuthorizedLangs();
        if (authorizedLangs != null) {
            for (Lang otherLang : authorizedLangs) {
                if (otherLang.equals(preferredLang) || rootLang != null && otherLang.equals(rootLang) || (motcle = this.getMotcleByLabel(labelString, otherLang)) == null || !motcle.getLabels().getFirstLabel().getLang().equals(otherLang)) continue;
                return motcle;
            }
        }
        return null;
    }

    default public Motcle getMotcleByIdString(String idString) throws NumberFormatException {
        if (this.isIdalphaType()) {
            Motcle motcle = this.getMotcleByIdalpha(idString);
            if (motcle != null) {
                return motcle;
            }
            try {
                int id = Integer.parseInt(idString);
                return this.getMotcleById(id);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        int id = Integer.parseInt(idString);
        return this.getMotcleById(id);
    }

    default public Motcle getFirst() {
        List<Motcle> firstLevel = this.getFirstLevelList();
        if (firstLevel.isEmpty()) {
            return null;
        }
        return firstLevel.get(0);
    }
}

