/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.syntax;

import java.io.IOException;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.GeopointItem;
import net.fichotheque.corpus.fiche.ImageItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.corpus.fiche.LinkItem;
import net.fichotheque.corpus.fiche.NumberItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.syntax.FicheblockSyntax;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.text.SeparatorOptions;

public final class FormSyntax {
    public static final SeparatorOptions DEFAULT_INLINE_SEPARATOROPTIONS = new SeparatorOptions(';', true, true);
    public static final SeparatorOptions DEFAULT_BLOCK_SEPARATOROPTIONS = new SeparatorOptions('\n', true, false);

    private FormSyntax() {
    }

    public static String toString(FicheItems ficheItems, FichothequeQuestioner fichothequeQuestioner, SeparatorOptions separatorOptions, Parameters parameters) {
        int size = ficheItems.size();
        if (size == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(128);
        for (int k = 0; k < size; ++k) {
            FicheItem ficheItem = (FicheItem)ficheItems.get(k);
            buf.append(FormSyntax.toString(ficheItem, fichothequeQuestioner, parameters));
            if (k < size - 1) {
                buf.append(separatorOptions.getSeparator());
                if (!separatorOptions.isSpaceInclude()) continue;
                buf.append(' ');
                continue;
            }
            if (!separatorOptions.isLastInclude()) continue;
            buf.append(separatorOptions.getSeparator());
            if (!separatorOptions.isSpaceInclude()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String toString(FicheItem item, FichothequeQuestioner fichothequeQuestioner, Parameters parameters) {
        if (item instanceof Item) {
            return FormSyntax.toString((Item)item);
        }
        if (item instanceof PersonItem) {
            return FormSyntax.toString((PersonItem)item, fichothequeQuestioner, FormSyntax.getDefaultSphereKey(parameters));
        }
        if (item instanceof LanguageItem) {
            return FormSyntax.toString((LanguageItem)item);
        }
        if (item instanceof CountryItem) {
            return FormSyntax.toString((CountryItem)item);
        }
        if (item instanceof DateItem) {
            return FormSyntax.toString((DateItem)item);
        }
        if (item instanceof EmailItem) {
            return FormSyntax.toString((EmailItem)item);
        }
        if (item instanceof LinkItem) {
            return FormSyntax.toString((LinkItem)item);
        }
        if (item instanceof NumberItem) {
            return FormSyntax.toString((NumberItem)item, FormSyntax.getDecimalChar(parameters));
        }
        if (item instanceof AmountItem) {
            return FormSyntax.toString((AmountItem)item, FormSyntax.getDecimalChar(parameters));
        }
        if (item instanceof GeopointItem) {
            return FormSyntax.toString((GeopointItem)item, FormSyntax.getDecimalChar(parameters));
        }
        if (item instanceof ParaItem) {
            return FormSyntax.toString((ParaItem)item);
        }
        if (item instanceof ImageItem) {
            return FormSyntax.toString((ImageItem)item);
        }
        throw new IllegalArgumentException("unknown FicheItem implementation");
    }

    public static String toString(DegreDecimal degreDecimal, Parameters parameters) {
        return degreDecimal.toDecimal().toStringWithBlank(FormSyntax.getDecimalChar(parameters));
    }

    public static String toString(ParaItem para) {
        StringBuilder buf = new StringBuilder();
        try {
            FicheblockSyntax.appendTextContent((Appendable)buf, (TextContent)para, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String toString(Item item) {
        String value = item.getValue();
        return FormSyntax.escapeString(value);
    }

    public static String escapeString(String s) {
        StringBuilder buf = new StringBuilder(s.length() + 20);
        FormSyntax.escapeString(buf, s);
        return buf.toString();
    }

    private static void escapeString(StringBuilder buf, String s) {
        try {
            FormSyntax.escapeString((Appendable)buf, s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void escapeString(Appendable buf, String s) throws IOException {
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\u00a0': 
                case '\u202f': {
                    buf.append('~');
                    continue block3;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
    }

    public static String toString(PersonItem personItem, FichothequeQuestioner fichothequeQuestioner, SubsetKey defaultSphereKey) {
        String userGlobalId = personItem.getRedacteurGlobalId();
        if (userGlobalId != null) {
            Redacteur redacteur = fichothequeQuestioner.getRedacteurByGlobalId(userGlobalId);
            if (redacteur != null) {
                if (defaultSphereKey != null && defaultSphereKey.equals(redacteur.getSubsetKey())) {
                    return redacteur.getLogin();
                }
                return redacteur.getBracketStyle();
            }
            return userGlobalId;
        }
        PersonCore personCore = personItem.getPersonCore();
        StringBuilder buf = new StringBuilder(64);
        FormSyntax.escapeString(buf, personCore.getSurname());
        buf.append('*');
        if (personCore.isSurnameFirst()) {
            buf.append('%');
        }
        FormSyntax.escapeString(buf, personCore.getForename());
        String organism = personItem.getOrganism();
        if (organism != null) {
            buf.append('*');
            FormSyntax.escapeString(buf, organism);
        }
        return buf.toString();
    }

    public static String toString(LanguageItem languageItem) {
        return languageItem.getLang().toString();
    }

    public static String toString(CountryItem countryItem) {
        return countryItem.getCountry().toString();
    }

    public static String toString(DateItem dateItem) {
        return dateItem.toString();
    }

    public static String toString(EmailItem emailItem) {
        return emailItem.toString();
    }

    public static String toString(LinkItem linkItem) {
        StringBuilder buf = new StringBuilder(128);
        String href = linkItem.getHref();
        buf.append(href);
        String title = linkItem.getTitle();
        if (title.length() == 0) {
            title = null;
        } else if (title.equals(href)) {
            title = null;
        } else if (href.length() > 8 && title.equals(href.substring(7))) {
            title = null;
        } else {
            buf.append('*');
            FormSyntax.escapeString(buf, title);
        }
        String comment = linkItem.getComment();
        if (comment.length() > 0) {
            if (title == null) {
                buf.append('*');
            }
            buf.append('*');
            FormSyntax.escapeString(buf, comment);
        }
        return buf.toString();
    }

    public static String toString(ImageItem imageItem) {
        StringBuilder buf = new StringBuilder(128);
        String src = imageItem.getSrc();
        String alt = imageItem.getAlt();
        String title = imageItem.getTitle();
        buf.append(src);
        if (alt.length() > 0) {
            buf.append('*');
            FormSyntax.escapeString(buf, alt);
        }
        if (title.length() > 0) {
            if (alt.length() == 0) {
                buf.append('*');
            }
            buf.append('*');
            FormSyntax.escapeString(buf, alt);
        }
        return buf.toString();
    }

    public static String toString(NumberItem numberItem, char decimalChar) {
        String valString = numberItem.getDecimal().toStringWithBlank(decimalChar);
        return valString;
    }

    public static String toString(AmountItem amountItem, char decimalChar) {
        String valString = amountItem.getDecimal().toStringWithBlank(decimalChar);
        String cur = amountItem.getCurrency().getCurrencyCode();
        return valString + cur;
    }

    public static String toString(GeopointItem geopointItem, char decimalChar) {
        StringBuilder buf = new StringBuilder();
        buf.append(geopointItem.getLatitude().toDecimal().toStringWithBlank(decimalChar));
        buf.append("* ");
        buf.append(geopointItem.getLongitude().toDecimal().toStringWithBlank(decimalChar));
        return buf.toString();
    }

    public static Parameters parameters() {
        return new Parameters();
    }

    public static Parameters parameters(Parameters others) {
        return new Parameters(others);
    }

    private static char getDecimalChar(Parameters parameters) {
        if (parameters == null) {
            return '.';
        }
        return parameters.decimalChar();
    }

    private static SubsetKey getDefaultSphereKey(Parameters parameters) {
        if (parameters == null) {
            return null;
        }
        return parameters.defautSphereKey();
    }

    public static class Parameters {
        private SubsetKey defautSphereKey = null;
        private char decimalChar = (char)46;

        private Parameters() {
        }

        private Parameters(Parameters other) {
            this.decimalChar = other.decimalChar;
            this.defautSphereKey = other.defautSphereKey;
        }

        public SubsetKey defautSphereKey() {
            return this.defautSphereKey;
        }

        public Parameters defautSphereKey(SubsetKey defautSphereKey) {
            this.defautSphereKey = defautSphereKey;
            return this;
        }

        public char decimalChar() {
            return this.decimalChar;
        }

        public Parameters decimalChar(char decimalChar) {
            this.decimalChar = decimalChar;
            return this;
        }
    }
}

