/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldGeneration;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.corpus.metadata.MandatoryFieldException;
import net.fichotheque.impl.AbstractMetadata;
import net.fichotheque.impl.CorpusImpl;
import net.fichotheque.impl.Listeners;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FieldOptionUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.CurrenciesUtils;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.LabelsCache;
import net.mapeadores.util.text.MultiStringable;

class CorpusMetadataImpl
extends AbstractMetadata
implements CorpusMetadata {
    private final CorpusImpl corpus;
    private final Map<FieldKey, CorpusFieldImpl> corpusFieldMap = new HashMap<FieldKey, CorpusFieldImpl>();
    private final List<CorpusFieldImpl> propFieldList = new ArrayList<CorpusFieldImpl>();
    private final List<CorpusFieldImpl> infoFieldList = new ArrayList<CorpusFieldImpl>();
    private final List<CorpusFieldImpl> sectionFieldList = new ArrayList<CorpusFieldImpl>();
    private CorpusField geolocalisationField;
    private List<CorpusField> propCacheList;
    private List<CorpusField> infoCacheList;
    private List<CorpusField> sectionCacheList;
    private FieldGeneration fieldGeneration = CorpusMetadataUtils.EMPTY_FIELDGENERATION;

    private CorpusMetadataImpl(CorpusImpl corpus) {
        this.corpus = corpus;
        try {
            this.createMandatoryCorpusField(FieldKey.ID);
            this.createMandatoryCorpusField(FieldKey.LANG);
            this.createMandatoryCorpusField(FieldKey.TITLE);
            this.createMandatoryCorpusField(FieldKey.OWNERS);
        }
        catch (ExistingFieldKeyException existingFieldKeyException) {
            // empty catch block
        }
    }

    static InitEditor fromInit(CorpusImpl.InitEditor corpusInitEditor) {
        CorpusMetadataImpl metadata = new CorpusMetadataImpl((CorpusImpl)corpusInitEditor.getCorpus());
        return new InitEditor(metadata, corpusInitEditor);
    }

    static CorpusMetadataImpl fromNew(CorpusImpl corpus) {
        return new CorpusMetadataImpl(corpus);
    }

    @Override
    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public CorpusField getCorpusField(FieldKey fieldKey) {
        return this.corpusFieldMap.get(fieldKey);
    }

    @Override
    public List<CorpusField> getPropList() {
        List<CorpusField> result = this.propCacheList;
        if (result == null) {
            result = this.initPropList();
        }
        return result;
    }

    @Override
    public List<CorpusField> getInfoList() {
        List<CorpusField> result = this.infoCacheList;
        if (result == null) {
            result = this.initInfoList();
        }
        return result;
    }

    @Override
    public List<CorpusField> getSectionList() {
        List<CorpusField> result = this.sectionCacheList;
        if (result == null) {
            result = this.initSectionList();
        }
        return result;
    }

    @Override
    public CorpusField getGeolocalisationField() {
        return this.geolocalisationField;
    }

    @Override
    public FieldGeneration getFieldGeneration() {
        return this.fieldGeneration;
    }

    CorpusMetadataEditor getCorpusMetadataEditor(CorpusImpl.CorpusEditorImpl corpusEditor) {
        return new CorpusMetadataEditorImpl(corpusEditor);
    }

    void clear() {
        this.sectionFieldList.clear();
        this.propFieldList.clear();
        this.infoFieldList.clear();
        this.corpusFieldMap.clear();
        this.clearCache();
    }

    private Listeners getListeners() {
        return this.corpus.getListeners();
    }

    private void clearCache() {
        this.propCacheList = null;
        this.infoCacheList = null;
        this.sectionCacheList = null;
    }

    @Override
    protected void fireChange(FichothequeEditor fichothequeEditor) {
        CorpusImpl.CorpusEditorImpl corpusEditor = (CorpusImpl.CorpusEditorImpl)fichothequeEditor.getCorpusEditor(this.corpus);
        corpusEditor.setMetadataChange();
    }

    private CorpusFieldImpl testCorpusField(CorpusField corpusField) throws IllegalArgumentException {
        if (!(corpusField instanceof CorpusFieldImpl)) {
            throw new IllegalArgumentException("corpusField argument does not come from this CorpusMetadata instance");
        }
        CorpusFieldImpl def = (CorpusFieldImpl)corpusField;
        if (def.getCorpusMetadata() != this) {
            throw new IllegalArgumentException("corpusField argument does not come from this CorpusMetadata instance");
        }
        return def;
    }

    private synchronized List<CorpusField> initPropList() {
        if (this.propCacheList != null) {
            return this.propCacheList;
        }
        List<CorpusField> list = CorpusMetadataUtils.wrap(this.propFieldList.toArray(new CorpusField[this.propFieldList.size()]));
        this.propCacheList = list;
        return list;
    }

    private synchronized List<CorpusField> initInfoList() {
        if (this.infoCacheList != null) {
            return this.infoCacheList;
        }
        List<CorpusField> list = CorpusMetadataUtils.wrap(this.infoFieldList.toArray(new CorpusField[this.infoFieldList.size()]));
        this.infoCacheList = list;
        return list;
    }

    private synchronized List<CorpusField> initSectionList() {
        if (this.sectionCacheList != null) {
            return this.sectionCacheList;
        }
        List<CorpusField> list = CorpusMetadataUtils.wrap(this.sectionFieldList.toArray(new CorpusField[this.sectionFieldList.size()]));
        this.sectionCacheList = list;
        return list;
    }

    private synchronized CorpusField createMandatoryCorpusField(FieldKey fieldKey) throws ExistingFieldKeyException {
        return this.innerCreateCorpusField(fieldKey, "");
    }

    private synchronized CorpusField innerCreateCorpusField(FieldKey fieldKey, String ficheItemType) throws ExistingFieldKeyException {
        CorpusFieldImpl corpusField;
        if (this.corpusFieldMap.containsKey(fieldKey)) {
            throw new ExistingFieldKeyException();
        }
        block0 : switch (fieldKey.getCategory()) {
            case 1: {
                ficheItemType = CorpusField.checkFicheItemType(ficheItemType);
                corpusField = new CorpusFieldImpl(fieldKey, ficheItemType);
                this.propFieldList.add(corpusField);
                break;
            }
            case 2: {
                ficheItemType = CorpusField.checkFicheItemType(ficheItemType);
                corpusField = new CorpusFieldImpl(fieldKey, ficheItemType);
                this.infoFieldList.add(corpusField);
                break;
            }
            case 3: {
                corpusField = new CorpusFieldImpl(fieldKey);
                this.sectionFieldList.add(corpusField);
                break;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "id": 
                    case "title": {
                        corpusField = new CorpusFieldImpl(fieldKey);
                        break block0;
                    }
                    case "subtitle": {
                        corpusField = new CorpusFieldImpl(fieldKey, "para");
                        break block0;
                    }
                    case "lang": {
                        corpusField = new CorpusFieldImpl(fieldKey, "language");
                        break block0;
                    }
                    case "owners": {
                        corpusField = new CorpusFieldImpl(fieldKey, "person");
                        break block0;
                    }
                }
                throw new SwitchException("Unknown special key = " + fieldKey.getKeyString());
            }
            default: {
                throw new SwitchException("unknown category = " + fieldKey.getCategory());
            }
        }
        this.corpusFieldMap.put(fieldKey, corpusField);
        for (FieldGeneration.Entry entry : this.fieldGeneration.getEntryList()) {
            if (!entry.getFieldKey().equals(fieldKey)) continue;
            corpusField.generated = true;
        }
        this.clearCache();
        return corpusField;
    }

    private boolean innerPutLabel(CorpusField corpusField, Label label) {
        CorpusFieldImpl corpusFieldImpl = this.testCorpusField(corpusField);
        return corpusFieldImpl.putLabel(label);
    }

    private boolean innerRemoveLabel(CorpusField corpusField, Lang lang) {
        CorpusFieldImpl corpusFieldImpl = this.testCorpusField(corpusField);
        return corpusFieldImpl.removeLabel(lang);
    }

    private boolean innerSetFieldOption(CorpusField corpusField, String optionName, Object optionValue) throws FieldOptionException {
        CorpusFieldImpl corpusFieldImpl = this.testCorpusField(corpusField);
        return corpusFieldImpl.setOption(optionName, optionValue);
    }

    private synchronized void innerRemoveCorpusField(CorpusField corpusField) throws MandatoryFieldException {
        CorpusFieldImpl corpusFieldImpl = this.testCorpusField(corpusField);
        FieldKey fieldKey = corpusFieldImpl.getFieldKey();
        if (fieldKey.isMandatoryField()) {
            throw new MandatoryFieldException();
        }
        this.corpusFieldMap.remove(fieldKey);
        switch (fieldKey.getCategory()) {
            case 1: {
                this.propFieldList.remove(corpusFieldImpl);
                if (this.geolocalisationField == null || !this.geolocalisationField.equals(corpusFieldImpl)) break;
                this.geolocalisationField = null;
                break;
            }
            case 2: {
                this.infoFieldList.remove(corpusFieldImpl);
                break;
            }
            case 3: {
                this.sectionFieldList.remove(corpusFieldImpl);
            }
        }
        for (CorpusFieldImpl otherCorpusfield : this.propFieldList) {
            FieldKeys corpusFieldList = (FieldKeys)otherCorpusfield.optionMap.get("addressFieldArray");
            if (corpusFieldList == null) continue;
            corpusFieldList.fieldKeyList.remove(fieldKey);
            if (!corpusFieldList.fieldKeyList.isEmpty()) continue;
            otherCorpusfield.optionMap.remove("addressFieldArray");
        }
        this.clearCache();
    }

    private boolean innerSetGeolocalisationField(CorpusField corpusField) {
        boolean done = false;
        if (corpusField == null) {
            if (this.geolocalisationField != null) {
                this.geolocalisationField = null;
                done = true;
            }
        } else {
            CorpusFieldImpl defcorpusfield = this.testCorpusField(corpusField);
            FieldKey fieldKey = defcorpusfield.getFieldKey();
            if (!fieldKey.isProp()) {
                throw new IllegalArgumentException("not a Prop field : " + fieldKey.getKeyString());
            }
            if (!corpusField.isType("geopoint")) {
                throw new IllegalArgumentException("not a GeoPoint Type : " + corpusField.getFicheItemType());
            }
            if (this.geolocalisationField == null) {
                this.geolocalisationField = defcorpusfield;
                done = true;
            } else if (!this.geolocalisationField.equals(defcorpusfield)) {
                this.geolocalisationField = defcorpusfield;
                done = true;
            }
        }
        return done;
    }

    private boolean innerSetFieldGeneration(FieldGeneration newFieldGeneration) {
        if (newFieldGeneration.getRawString().equals(this.fieldGeneration.getRawString())) {
            return false;
        }
        this.fieldGeneration = newFieldGeneration;
        for (CorpusFieldImpl corpusFieldImpl : this.corpusFieldMap.values()) {
            corpusFieldImpl.generated = false;
        }
        for (FieldGeneration.Entry fieldGenerationEntry : newFieldGeneration.getEntryList()) {
            CorpusFieldImpl corpusFieldImpl = this.corpusFieldMap.get(fieldGenerationEntry.getFieldKey());
            if (corpusFieldImpl == null) continue;
            corpusFieldImpl.generated = true;
        }
        return true;
    }

    static class InitEditor
    implements CorpusMetadataEditor {
        private final CorpusMetadataImpl corpusMetadata;
        private final CorpusEditor corpusEditor;

        private InitEditor(CorpusMetadataImpl corpusMetadata, CorpusEditor corpusEditor) {
            this.corpusMetadata = corpusMetadata;
            this.corpusEditor = corpusEditor;
        }

        @Override
        public Metadata getMetadata() {
            return this.corpusMetadata;
        }

        @Override
        public CorpusEditor getCorpusEditor() {
            return this.corpusEditor;
        }

        @Override
        public CorpusField createCorpusField(FieldKey fieldKey, String ficheItemType) throws ExistingFieldKeyException {
            return this.corpusMetadata.innerCreateCorpusField(fieldKey, ficheItemType);
        }

        @Override
        public boolean putFieldLabel(CorpusField corpusField, Label label) {
            return this.corpusMetadata.innerPutLabel(corpusField, label);
        }

        @Override
        public boolean removeFieldLabel(CorpusField corpusField, Lang lang) {
            return this.corpusMetadata.innerRemoveLabel(corpusField, lang);
        }

        @Override
        public boolean putLabel(String name, Label label) {
            return this.corpusMetadata.innerPutLabel(name, label);
        }

        @Override
        public boolean removeLabel(String name, Lang lang) {
            return this.corpusMetadata.innerRemoveLabel(name, lang);
        }

        @Override
        public boolean setFieldOption(CorpusField corpusField, String optionName, Object optionValue) throws FieldOptionException {
            return this.corpusMetadata.innerSetFieldOption(corpusField, optionName, optionValue);
        }

        @Override
        public void removeCorpusField(CorpusField corpusField) throws MandatoryFieldException {
            this.corpusMetadata.innerRemoveCorpusField(corpusField);
        }

        @Override
        public boolean setGeolocalisationField(CorpusField corpusField) {
            return this.corpusMetadata.innerSetGeolocalisationField(corpusField);
        }

        @Override
        public boolean setFieldGeneration(FieldGeneration fieldGeneration) {
            return this.corpusMetadata.innerSetFieldGeneration(fieldGeneration);
        }
    }

    private class CorpusMetadataEditorImpl
    implements CorpusMetadataEditor {
        private final CorpusImpl.CorpusEditorImpl corpusEditor;

        private CorpusMetadataEditorImpl(CorpusImpl.CorpusEditorImpl corpusEditor) {
            this.corpusEditor = corpusEditor;
        }

        @Override
        public Metadata getMetadata() {
            return CorpusMetadataImpl.this;
        }

        @Override
        public CorpusEditor getCorpusEditor() {
            return this.corpusEditor;
        }

        @Override
        public CorpusField createCorpusField(FieldKey fieldKey, String ficheItemType) throws ExistingFieldKeyException {
            CorpusField corpusField = CorpusMetadataImpl.this.innerCreateCorpusField(fieldKey, ficheItemType);
            this.fireChange();
            CorpusMetadataImpl.this.getListeners().fireCorpusFieldCreated(this.corpusEditor.getFichothequeEditor(), CorpusMetadataImpl.this.corpus, corpusField);
            return corpusField;
        }

        @Override
        public boolean putFieldLabel(CorpusField corpusField, Label label) {
            boolean done = CorpusMetadataImpl.this.innerPutLabel(corpusField, label);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean removeFieldLabel(CorpusField corpusField, Lang lang) {
            boolean done = CorpusMetadataImpl.this.innerRemoveLabel(corpusField, lang);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean putLabel(String name, Label label) {
            boolean done = CorpusMetadataImpl.this.innerPutLabel(name, label);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean removeLabel(String name, Lang lang) {
            boolean done = CorpusMetadataImpl.this.innerRemoveLabel(name, lang);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean setFieldOption(CorpusField corpusField, String optionName, Object optionValue) throws FieldOptionException {
            boolean done = CorpusMetadataImpl.this.innerSetFieldOption(corpusField, optionName, optionValue);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public void removeCorpusField(CorpusField corpusField) throws MandatoryFieldException {
            FieldKey fieldKey = corpusField.getFieldKey();
            CorpusMetadataImpl.this.innerRemoveCorpusField(corpusField);
            this.fireChange();
            CorpusMetadataImpl.this.getListeners().fireCorpusFieldRemoved(this.corpusEditor.getFichothequeEditor(), CorpusMetadataImpl.this.corpus, fieldKey);
        }

        @Override
        public boolean setGeolocalisationField(CorpusField corpusField) {
            boolean done = CorpusMetadataImpl.this.innerSetGeolocalisationField(corpusField);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        @Override
        public boolean setFieldGeneration(FieldGeneration fieldGeneration) {
            boolean done = CorpusMetadataImpl.this.innerSetFieldGeneration(fieldGeneration);
            if (done) {
                this.fireChange();
            }
            return done;
        }

        private void fireChange() {
            this.corpusEditor.setMetadataChange();
        }
    }

    private class CorpusFieldImpl
    implements CorpusField {
        private final FieldKey fieldKey;
        private final String ficheItemType;
        private final LabelsCache labelsCache = new LabelsCache();
        private final SortedMap<String, Object> optionMap = new TreeMap<String, Object>();
        private boolean generated;

        private CorpusFieldImpl(FieldKey fieldKey) {
            this(fieldKey, "");
        }

        private CorpusFieldImpl(FieldKey fieldKey, String ficheItemType) {
            this.fieldKey = fieldKey;
            this.ficheItemType = ficheItemType;
        }

        @Override
        public FieldKey getFieldKey() {
            return this.fieldKey;
        }

        @Override
        public CorpusMetadata getCorpusMetadata() {
            return CorpusMetadataImpl.this;
        }

        @Override
        public String getFicheItemType() {
            return this.ficheItemType;
        }

        @Override
        public Object getOption(String optionName) {
            return this.optionMap.get(optionName);
        }

        @Override
        public Set<String> getOptionNameSet() {
            return Collections.unmodifiableSet(this.optionMap.keySet());
        }

        @Override
        public Labels getLabels() {
            return this.labelsCache.getLabels();
        }

        @Override
        public boolean isGenerated() {
            return this.generated;
        }

        private boolean putLabel(Label label) {
            return this.labelsCache.putLabel(label);
        }

        private boolean removeLabel(Lang lang) {
            return this.labelsCache.removeLabel(lang);
        }

        private boolean setOption(String optionName, Object optionValue) throws FieldOptionException {
            if (optionValue == null) {
                if (this.optionMap.containsKey(optionName)) {
                    this.optionMap.remove(optionName);
                    return true;
                }
                return false;
            }
            FieldOptionUtils.checkUsage(optionName, this.fieldKey, this.ficheItemType);
            switch (optionName) {
                case "currencyArray": {
                    return this.setCurrencies(optionName, optionValue);
                }
                case "addressFieldArray": {
                    return this.setFieldKeys(optionName, optionValue);
                }
                case "langArray": {
                    return this.setLangs(optionName, optionValue);
                }
            }
            return this.setString(optionName, optionValue);
        }

        private boolean setString(String optionName, Object optionValue) throws FieldOptionException {
            if (!(optionValue instanceof String)) {
                throw new FieldOptionException("value must be a String");
            }
            String stringValue = (String)optionValue;
            FieldOptionUtils.checkString(optionName, stringValue);
            String currentValue = (String)this.optionMap.get(optionName);
            if (currentValue == null) {
                this.optionMap.put(optionName, optionValue);
                return true;
            }
            if (currentValue.equals(optionValue)) {
                return false;
            }
            this.optionMap.put(optionName, optionValue);
            return true;
        }

        private boolean setCurrencies(String optionName, Object optionValue) throws FieldOptionException {
            LinkedHashSet<ExtendedCurrency> currencySet = new LinkedHashSet<ExtendedCurrency>();
            if (optionValue instanceof ExtendedCurrency[]) {
                ExtendedCurrency[] currencyArray;
                for (ExtendedCurrency currency : currencyArray = (ExtendedCurrency[])optionValue) {
                    currencySet.add(currency);
                }
            } else if (optionValue instanceof Currencies) {
                currencySet.addAll((Currencies)optionValue);
            } else {
                throw new FieldOptionException("optionValue must be an instance of ExtendedCurrency[] or Currencies");
            }
            Currencies currentCurrencies = (Currencies)this.optionMap.get(optionName);
            if (currencySet.isEmpty()) {
                if (currentCurrencies == null) {
                    return false;
                }
                this.optionMap.remove(optionName);
                return true;
            }
            if (currentCurrencies != null && CurrenciesUtils.areEquals(currentCurrencies, currencySet)) {
                return false;
            }
            this.optionMap.put(optionName, CurrenciesUtils.fromCollection(currencySet));
            return true;
        }

        private boolean setLangs(String optionName, Object optionValue) throws FieldOptionException {
            LinkedHashSet<Lang> langSet = new LinkedHashSet<Lang>();
            if (optionValue instanceof Lang[]) {
                Lang[] langArray;
                for (Lang lang : langArray = (Lang[])optionValue) {
                    langSet.add(lang);
                }
            } else if (optionValue instanceof Langs) {
                langSet.addAll((Langs)optionValue);
            } else {
                throw new FieldOptionException("optionValue must be an instance of Lang[] or Langs");
            }
            Langs currentLangs = (Langs)this.optionMap.get(optionName);
            if (langSet.isEmpty()) {
                if (currentLangs == null) {
                    return false;
                }
                this.optionMap.remove(optionName);
                return true;
            }
            if (currentLangs != null && LangsUtils.areEquals(currentLangs, langSet)) {
                return false;
            }
            this.optionMap.put(optionName, LangsUtils.fromCollection(langSet));
            return true;
        }

        private boolean setFieldKeys(String optionName, Object optionValue) throws FieldOptionException {
            FieldKey[] newArray = null;
            if (!(optionValue instanceof FieldKey[])) {
                throw new FieldOptionException("optionValue must be an instance of FieldKey[]");
            }
            newArray = (FieldKey[])optionValue;
            FieldKeys fieldKeys = new FieldKeys();
            for (FieldKey newFieldKey : newArray) {
                CorpusField corpusField = CorpusMetadataImpl.this.getCorpusField(newFieldKey);
                if (corpusField == null) continue;
                fieldKeys.fieldKeyList.add(corpusField.getFieldKey());
            }
            FieldKeys currentFieldKeys = (FieldKeys)this.optionMap.get(optionName);
            if (fieldKeys.fieldKeyList.isEmpty()) {
                if (currentFieldKeys == null) {
                    return false;
                }
                this.optionMap.remove(optionName);
                return true;
            }
            if (currentFieldKeys != null && currentFieldKeys.isSame(fieldKeys)) {
                return false;
            }
            this.optionMap.put(optionName, fieldKeys);
            return true;
        }
    }

    private static class FieldKeys
    implements MultiStringable {
        private List<FieldKey> fieldKeyList = new ArrayList<FieldKey>();

        private FieldKeys() {
        }

        @Override
        public String[] toStringArray() {
            int length = this.fieldKeyList.size();
            String[] array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.fieldKeyList.get(i).getKeyString();
            }
            return array;
        }

        @Override
        public String toString(String separator) {
            StringBuilder buf = new StringBuilder();
            int length = this.fieldKeyList.size();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(separator);
                }
                buf.append(this.fieldKeyList.get(i).getKeyString());
            }
            return buf.toString();
        }

        @Override
        public int getStringSize() {
            return this.fieldKeyList.size();
        }

        @Override
        public String getStringValue(int index) {
            return this.fieldKeyList.get(index).getKeyString();
        }

        private boolean isSame(FieldKeys other) {
            int length = this.fieldKeyList.size();
            if (other.fieldKeyList.size() != length) {
                return false;
            }
            if (length == 0) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                if (this.fieldKeyList.get(i).equals(other.fieldKeyList.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

