/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.SpecialIncludeUi;
import fr.exemole.bdfserver.api.ui.UiComponent;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.include.ExtendedIncludeKey;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.text.CleanedString;

public class OverviewEngine {
    public static final String SEVERE_SYNTAX = "severe.overview.syntax";
    public static final String SEVERE_FICHOTHEQUE = "severe.overview.fichotheque";
    private final BdfServer bdfServer;
    private final Corpus corpus;
    private final LineMessageHandler lineMessageHandler;
    private final UiComponents uiComponents;
    private final Map<String, OverviewBlock> blockMap = new LinkedHashMap<String, OverviewBlock>();

    public OverviewEngine(BdfServer bdfServer, Corpus corpus, LineMessageHandler lineMessageHandler) {
        this.bdfServer = bdfServer;
        this.corpus = corpus;
        this.lineMessageHandler = lineMessageHandler;
        this.uiComponents = bdfServer.getUiManager().getMainUiComponents(corpus);
    }

    public boolean run(EditSession editSession) {
        for (OverviewBlock overviewBlock : this.blockMap.values()) {
            overviewBlock.firstPass(editSession, this.uiComponents);
        }
        for (OverviewBlock overviewBlock : this.blockMap.values()) {
            overviewBlock.secondPass(editSession, this.uiComponents);
        }
        return true;
    }

    public void parse(String text) {
        for (RawBlock block : this.firstScan(text)) {
            try {
                OverviewBlock overviewBlock = this.parseBlock(block);
                for (RawLine rawLine : block.lineList) {
                    this.addLine(overviewBlock, rawLine);
                }
            }
            catch (LineMessageException lme) {
                this.lineMessageHandler.addMessage(lme);
            }
        }
    }

    private List<RawBlock> firstScan(String text) {
        ArrayList<RawBlock> blockList = new ArrayList<RawBlock>();
        RawBlock currentBlock = null;
        BufferedReader bufReader = new BufferedReader(new StringReader(text));
        int lineNumber = 0;
        try {
            String line;
            block6: while ((line = bufReader.readLine()) != null) {
                line = line.trim();
                ++lineNumber;
                if (line.length() == 0) continue;
                switch (line.charAt(0)) {
                    case '!': 
                    case '#': 
                    case ';': 
                    case '=': {
                        continue block6;
                    }
                    case '[': {
                        int closeIdx = line.indexOf("]");
                        String header = closeIdx > 0 ? line.substring(1, closeIdx).trim() : line.substring(1).trim();
                        if (header.isEmpty()) {
                            this.lineMessageHandler.addMessage(SEVERE_SYNTAX, lineNumber, "_ error.wrong.conf.header", line);
                            currentBlock = null;
                            continue block6;
                        }
                        currentBlock = new RawBlock(lineNumber, header);
                        blockList.add(currentBlock);
                        continue block6;
                    }
                }
                int idx = line.indexOf(61);
                if (idx < 1) {
                    this.lineMessageHandler.addMessage(SEVERE_SYNTAX, lineNumber, "_ error.wrong.conf.missingseparator", new Object[0]);
                    continue;
                }
                if (currentBlock == null) continue;
                String key = line.substring(0, idx).trim();
                String value = OverviewEngine.unscape(line.substring(idx + 1).trim());
                currentBlock.addLine(lineNumber, key, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return blockList;
    }

    private OverviewBlock parseBlock(RawBlock rawBlock) throws LineMessageException {
        String name = rawBlock.header;
        OverviewBlock existing = this.blockMap.get(name);
        if (existing != null) {
            return existing;
        }
        UiComponent uiComponent = this.uiComponents.getUiComponent(name);
        OverviewBlock newBlock = uiComponent != null ? OverviewBlock.fromUiComponent(rawBlock.lineNumber, this.bdfServer, uiComponent, this.corpus.getCorpusMetadata()) : this.parseName(rawBlock);
        if (newBlock != null) {
            this.blockMap.put(name, newBlock);
            return newBlock;
        }
        return null;
    }

    private void addLine(OverviewBlock currentBlock, RawLine rawLine) throws LineMessageException {
        String key = rawLine.key;
        int lineNumber = rawLine.lineNumber;
        String value = rawLine.value;
        int idx = key.indexOf(58);
        if (idx != -1) {
            try {
                AttributeKey attributeKey = AttributeKey.parse(key);
                List<CleanedString> list = AttributeParser.parseValues(value);
                currentBlock.addAttribute(attributeKey, list);
            }
            catch (ParseException pe) {
                throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.wrong.conf.attributekey", key);
            }
            return;
        }
        int idx2 = key.indexOf(124);
        if (idx2 != -1) {
            String labelKey = key.substring(0, idx2);
            String langCode = key.substring(idx2 + 1);
            try {
                Lang lang = Lang.parse(langCode);
                boolean done = currentBlock.addText(labelKey, lang, value);
                if (!done) {
                    throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.unknown.conf.key", labelKey);
                }
            }
            catch (ParseException pe) {
                throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.wrong.lang", langCode);
            }
            return;
        }
        int idx3 = key.indexOf(95);
        if (idx3 == -1) {
            idx3 = key.indexOf(46);
        }
        if (idx3 != -1) {
            currentBlock.put(lineNumber, key.substring(0, idx3), key.substring(idx3 + 1), value);
        } else {
            currentBlock.put(lineNumber, key, value);
        }
    }

    private OverviewBlock parseName(RawBlock rawBlock) throws LineMessageException {
        int lineNumber = rawBlock.lineNumber;
        String name = rawBlock.header;
        if (name.equals("metadata")) {
            return OverviewBlock.metadata(lineNumber, this.corpus.getCorpusMetadata());
        }
        try {
            FieldKey fieldKey = FieldKey.parse(name);
            String ficheItemType = "";
            if (fieldKey.isInfo() || fieldKey.isProp()) {
                if (rawBlock.typeLine == null) {
                    throw new LineMessageException(lineNumber, SEVERE_FICHOTHEQUE, "_ error.wrong.conf.missingtype");
                }
                try {
                    ficheItemType = CorpusField.checkFicheItemType(rawBlock.typeLine.value);
                }
                catch (IllegalArgumentException iae) {
                    throw new LineMessageException(rawBlock.typeLine.lineNumber, SEVERE_FICHOTHEQUE, "_ error.unknown.parametervalue", rawBlock.typeLine.key, rawBlock.typeLine.value);
                }
            }
            return OverviewBlock.fieldKey(lineNumber, fieldKey, ficheItemType, this.corpus.getCorpusMetadata());
        }
        catch (ParseException pe) {
            try {
                ExtendedIncludeKey includeKey = ExtendedIncludeKey.parse(name);
                this.testIncludeKey(lineNumber, includeKey);
                return OverviewBlock.includeKey(lineNumber, includeKey);
            }
            catch (ParseException pe2) {
                try {
                    String specialName = SpecialIncludeUi.checkSpecialIncludeName(name);
                    return OverviewBlock.specialInclude(lineNumber, specialName);
                }
                catch (IllegalArgumentException iae) {
                    if (name.startsWith("data_")) {
                        String dataName = name.substring("data_".length());
                        try {
                            DataUi.checkDataName(dataName);
                            if (rawBlock.typeLine == null) {
                                throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.wrong.conf.missingtype");
                            }
                            return OverviewBlock.externalData(lineNumber, dataName, rawBlock.typeLine.value);
                        }
                        catch (ParseException pe3) {
                            throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.wrong.dataname", dataName);
                        }
                    }
                    if (name.startsWith("comment_")) {
                        String commentName = name.substring("comment_".length());
                        try {
                            CommentUi.checkCommentName(commentName);
                            return OverviewBlock.comment(lineNumber, this.bdfServer, commentName);
                        }
                        catch (ParseException pe3) {
                            throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.wrong.conf.header", commentName);
                        }
                    }
                    throw new LineMessageException(lineNumber, SEVERE_SYNTAX, "_ error.wrong.conf.header", name);
                }
            }
        }
    }

    private void testIncludeKey(int lineNumber, ExtendedIncludeKey includeKey) throws LineMessageException {
        Subset subset = this.bdfServer.getFichotheque().getSubset(includeKey.getSubsetKey());
        if (subset == null) {
            throw new LineMessageException(lineNumber, SEVERE_FICHOTHEQUE, "_ error.unknown.subset", includeKey.getSubsetKey().toString());
        }
        if (includeKey.isMaster() && this.corpus.getMasterSubset() == null) {
            throw new LineMessageException(lineNumber, SEVERE_FICHOTHEQUE, "_ error.unsupported.notsatellitecorpus", includeKey.toString());
        }
    }

    private static String unscape(String value) {
        StringBuilder buf = new StringBuilder();
        int length = value.length();
        block11: for (int i = 0; i < length; ++i) {
            char carac = value.charAt(i);
            switch (carac) {
                case '\\': {
                    if (i == length - 1) {
                        buf.append(carac);
                        continue block11;
                    }
                    char nextChar = value.charAt(i + 1);
                    ++i;
                    switch (nextChar) {
                        case '\\': {
                            buf.append('\\');
                            continue block11;
                        }
                        case 'n': {
                            buf.append('\n');
                            continue block11;
                        }
                        case 'r': {
                            buf.append('\r');
                            continue block11;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block11;
                        }
                        case '\u00b6': {
                            buf.append('\u00b6');
                            continue block11;
                        }
                    }
                    buf.append('\\');
                    buf.append(nextChar);
                    continue block11;
                }
                case '\u00b6': {
                    buf.append('\n');
                    continue block11;
                }
                default: {
                    buf.append(carac);
                }
            }
        }
        return buf.toString();
    }

    private static class RawBlock {
        private final int lineNumber;
        private final String header;
        private final List<RawLine> lineList = new ArrayList<RawLine>();
        private RawLine typeLine;

        private RawBlock(int lineNumber, String header) {
            this.lineNumber = lineNumber;
            this.header = header;
        }

        private void addLine(int lineNumber, String key, String value) {
            RawLine rawLine = new RawLine(lineNumber, key, value);
            this.lineList.add(rawLine);
            if (key.equals("type") && this.typeLine == null) {
                this.typeLine = rawLine;
            }
        }
    }

    private static class RawLine {
        private final int lineNumber;
        private final String key;
        private final String value;

        private RawLine(int lineNumber, String key, String value) {
            this.lineNumber = lineNumber;
            this.key = key;
            this.value = value;
        }
    }
}

