/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.interaction.Domain;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.request.RequestMap;

public class OutputParametersBuilder {
    private OutputParametersBuilder() {
    }

    public static OutputParameters build(String output, Domain defaultDomain, BdfServer bdfServer, RequestMap requestMap, BdfUser bdfUser, BdfCommandResult bdfCommandResult) {
        Domain domain;
        int idx = output.indexOf(58);
        if (idx == -1) {
            idx = output.indexOf(47);
        }
        if (idx == -1) {
            domain = defaultDomain;
        } else {
            domain = Domain.parse(output.substring(0, idx));
            output = output.substring(idx + 1);
        }
        return new InternalOutputParameters(output, bdfServer, requestMap, bdfUser, bdfCommandResult, domain);
    }

    private static class InternalOutputParameters
    implements OutputParameters {
        private final String output;
        private final BdfServer bdfServer;
        private final RequestMap requestMap;
        private final BdfUser bdfUser;
        private final BdfCommandResult bdfCommandResult;
        private final Domain domain;
        private PermissionSummary permissionSummary = null;

        private InternalOutputParameters(String output, BdfServer bdfServer, RequestMap requestMap, BdfUser bdfUser, BdfCommandResult bdfCommandResult, Domain domain) {
            this.output = output;
            this.bdfServer = bdfServer;
            this.requestMap = requestMap;
            this.bdfUser = bdfUser;
            this.bdfCommandResult = bdfCommandResult;
            this.domain = domain;
        }

        @Override
        public String getOutput() {
            return this.output;
        }

        @Override
        public BdfServer getBdfServer() {
            return this.bdfServer;
        }

        @Override
        public RequestMap getRequestMap() {
            return this.requestMap;
        }

        @Override
        public BdfUser getBdfUser() {
            return this.bdfUser;
        }

        @Override
        public BdfCommandResult getBdfCommandResult() {
            return this.bdfCommandResult;
        }

        @Override
        public Domain getDomain() {
            return this.domain;
        }

        @Override
        public PermissionSummary getPermissionSummary() {
            if (this.permissionSummary == null) {
                this.permissionSummary = PermissionSummaryBuilder.build(this.bdfServer, this.bdfUser);
            }
            return this.permissionSummary;
        }
    }
}

