/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.externalsource;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.externalsource.FichothequeSharing;
import fr.exemole.bdfserver.tools.externalsource.CorpusExternalSource;
import fr.exemole.bdfserver.tools.externalsource.WikidataExternalSource;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.externalsource.ExternalSource;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.externalsource.ExternalSourceProvider;

public class CoreExternalSourceProvider
implements ExternalSourceProvider {
    private final BdfServer bdfServer;

    public CoreExternalSourceProvider(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    @Override
    public ExternalSource getExternalSource(ExternalSourceDef externalSourceDef) {
        switch (externalSourceDef.getType()) {
            case "fichothequecorpus": {
                FichothequeSharing fichothequeSharing = (FichothequeSharing)this.bdfServer.getContextObject("fichothequeSharing");
                if (fichothequeSharing != null) {
                    return this.getSource(fichothequeSharing, externalSourceDef);
                }
                return null;
            }
            case "wikidata": {
                return new WikidataExternalSource();
            }
        }
        return null;
    }

    private CorpusExternalSource getSource(FichothequeSharing fichothequeSharing, ExternalSourceDef externalSourceDef) {
        String fichothequeName = externalSourceDef.getParam("fichotheque");
        if (fichothequeName == null) {
            return null;
        }
        Fichotheque otherFichotheque = fichothequeSharing.getFichotheque(fichothequeName);
        if (otherFichotheque == null) {
            return null;
        }
        String corpusName = externalSourceDef.getParam("corpus");
        Corpus otherCorpus = otherFichotheque.getCorpus(corpusName);
        if (otherCorpus == null) {
            return null;
        }
        return new CorpusExternalSource(this.bdfServer, fichothequeName, otherCorpus, fichothequeSharing.getFichothequeQuestioner(fichothequeName));
    }
}

