/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.namespaces.FicheFormSpace;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.DataUi;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.exportation.transformation.BdfTransformationUtils;
import fr.exemole.bdfserver.tools.exportation.transformation.defaulttemplates.DefaultTemplateUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.namespaces.TransformationSpace;
import net.fichotheque.xml.extraction.TagNames;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.xml.XsltWriter;

public class AbstractFicheXsltWriter
extends XsltWriter {
    private static TransformationVariant SECTION_VARIANT = new TransformationVariant("component-Section");
    private static TransformationVariant FIELD_VARIANT = new TransformationVariant("component-FieldReference");
    protected final BdfServer bdfServer;
    protected final UiManager uiManager;
    protected final int extractVersion;
    protected final boolean uniqueLang;
    protected final TagNames tagNames;

    public AbstractFicheXsltWriter(BdfServer bdfServer, int extractVersion) {
        this.bdfServer = bdfServer;
        this.uiManager = bdfServer.getUiManager();
        this.extractVersion = extractVersion;
        this.uniqueLang = BdfTransformationUtils.isUniquelang(bdfServer);
        this.tagNames = new TagNames(extractVersion);
    }

    public void appendCommentUi(CommentUi commentUi) throws IOException {
        String firstValue;
        if (!commentUi.isTemplate()) {
            return;
        }
        Attribute condition = commentUi.getAttributes().getAttribute(FicheFormSpace.CONDITION_ATTRIBUTEKEY);
        boolean conditionDone = false;
        if (condition != null && (firstValue = condition.getFirstValue().replace('\'', '!')).startsWith("~")) {
            this.openXslIf("*[contains(@groups, '" + firstValue + "')]", true);
            this.appendCommentUiCall(commentUi);
            this.closeXslIf(true);
            conditionDone = true;
        }
        if (!conditionDone) {
            this.appendCommentUiCall(commentUi);
        }
        this.addSeparator();
    }

    private void appendCommentUiCall(CommentUi commentUi) throws IOException {
        this.openXslCallTemplate("component-addRawText", true);
        if (commentUi.isForm()) {
            this.addXslWithParam("param_ComponentName", commentUi.getCloneName(), true);
        }
        this.addXslWithParam("param_Text", "$label[@name='" + commentUi.getName() + "']", false);
        this.closeXslCallTemplate(true);
    }

    public void appendFieldUi(FieldUi fieldUi, CorpusMetadata corpusMetadata) throws IOException {
        if (!this.acceptUi(fieldUi)) {
            return;
        }
        FieldKey fieldKey = fieldUi.getFieldKey();
        CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
        String mode = "component-Inline";
        String select = null;
        Map paramMap = null;
        block0 : switch (fieldKey.getCategory()) {
            case 1: {
                select = this.tagNames.getPropTagName() + "[@name='" + fieldKey.getFieldName() + "']";
                break;
            }
            case 3: {
                select = "section[@name='" + fieldKey.getFieldName() + "']";
                TransformationVariant variant = AbstractFicheXsltWriter.getSectionVariant(fieldUi);
                mode = variant.getMode();
                paramMap = variant.getParamMap();
                break;
            }
            case 2: {
                select = this.tagNames.getInfoTagName() + "[@name='" + fieldKey.getFieldName() + "']";
                mode = DefaultTemplateUtils.getMode(corpusField);
                break;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "lang": {
                        select = "lang";
                        break block0;
                    }
                    case "owners": {
                        select = this.tagNames.getOwnersTagName();
                    }
                }
            }
        }
        if (select != null) {
            this.apply(select, mode, fieldUi.getFieldString(), paramMap);
        }
    }

    public void appendSubsetIncludeUi(SubsetIncludeUi includeUi) throws IOException {
        String select = this.tagNames.getSubsetTagName(includeUi.getCategory()) + "[@name='" + includeUi.getName() + "']";
        String mode = DefaultTemplateUtils.getMode(includeUi);
        this.apply(select, mode, includeUi.getName());
    }

    public void appendDataUi(DataUi dataUi) throws IOException {
        this.apply("data[@name='" + dataUi.getDataName() + "']", "component-Listitem", dataUi.getName());
    }

    public void appendChrono() throws IOException {
        this.openXslApplyTemplates(".", "component-Chrono", true);
        this.addXslWithParam("param_CreationLabel", "$label[@name='date_creation']", false);
        this.addXslWithParam("param_ModificationLabel", "$label[@name='date_modification']", false);
        this.closeXslApplyTemplates(true);
        this.addSeparator();
    }

    public void apply(String match, String mode) throws IOException {
        this.appendIndent();
        this.addXslApplyTemplates(match, mode);
    }

    public void apply(String select, String mode, String labelName) throws IOException {
        this.apply(select, mode, labelName, null);
    }

    public void apply(String select, String mode, String labelName, Map<String, String> paramMap) throws IOException {
        this.openXslApplyTemplates(select, mode, true);
        this.addXslWithParam("param_Label", "$label[@name='" + labelName + "']", false);
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                this.addXslWithParam(entry.getKey(), entry.getValue(), true);
            }
        }
        this.closeXslApplyTemplates(true);
        this.addSeparator();
    }

    public boolean acceptUi(FieldUi fieldUi) {
        switch (fieldUi.getFieldString()) {
            case "title": 
            case "subtitle": {
                return false;
            }
            case "lang": {
                return !this.uniqueLang;
            }
        }
        return true;
    }

    private static TransformationVariant getSectionVariant(FieldUi fieldUi) {
        Attribute attribute = fieldUi.getAttributes().getAttribute(TransformationSpace.VARIANT_KEY);
        if (attribute != null) {
            switch (attribute.getFirstValue()) {
                case "heading": {
                    LinkedHashMap<String, String> paramMap = null;
                    int size = attribute.size();
                    if (size > 1) {
                        paramMap = new LinkedHashMap<String, String>();
                        for (int i = 1; i < size; ++i) {
                            String value = (String)attribute.get(i);
                            if (!value.startsWith("class=")) continue;
                            String classValue = value.substring("class=".length());
                            paramMap.put("param_HeadingClass", classValue);
                        }
                    }
                    return new TransformationVariant("component-Heading", paramMap);
                }
                case "field": {
                    return FIELD_VARIANT;
                }
            }
        }
        return SECTION_VARIANT;
    }

    private static class TransformationVariant {
        private final String mode;
        private final Map<String, String> paramMap;

        private TransformationVariant(String mode) {
            this.mode = mode;
            this.paramMap = null;
        }

        private TransformationVariant(String mode, Map<String, String> paramMap) {
            this.mode = mode;
            this.paramMap = paramMap;
        }

        private String getMode() {
            return this.mode;
        }

        private Map<String, String> getParamMap() {
            return this.paramMap;
        }
    }
}

