/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.table;

import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.exportation.table.FormatColDef;
import net.fichotheque.format.FormatSourceKey;
import net.fichotheque.format.SubsetPathKey;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.namespaces.FormatSpace;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.format.FichothequeFormatDefBuilder;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.format.FormatConstants;

public final class BdfColDefs {
    private BdfColDefs() {
    }

    public static FormatColDef chrono(FichothequeFormatDefBuilder formatDefBuilder, String name, String patternMode) {
        formatDefBuilder.addSource(FormatSourceKey.newSpecialIncludeNameInstance(name));
        switch (patternMode) {
            case "standard": 
            case "code": {
                formatDefBuilder.addFormatPattern("{iso}").setCastType("date").putStringValue("datestyle", "short");
                break;
            }
            case "formsyntax": {
                formatDefBuilder.addFormatPattern("{formsyntax}");
                break;
            }
            case "label": {
                formatDefBuilder.addFormatPattern("{label}");
            }
        }
        return TableDefUtils.toFormatColDef(name, formatDefBuilder.toFichothequeFormatDef());
    }

    public static FormatColDef liage(FichothequeFormatDefBuilder formatDefBuilder, String patternMode) {
        formatDefBuilder.addSource(FormatSourceKey.newSpecialIncludeNameInstance("liage"));
        switch (patternMode) {
            case "standard": 
            case "label": {
                formatDefBuilder.addFormatPattern("{title}").putStringValue("sep", ", ");
                break;
            }
            case "code": {
                formatDefBuilder.addFormatPattern("{corpus}/{id}");
                break;
            }
            case "formsyntax": {
                formatDefBuilder.addFormatPattern("{formsyntax}");
            }
        }
        return TableDefUtils.toFormatColDef("liage", formatDefBuilder.toFichothequeFormatDef());
    }

    public static FormatColDef corpusField(FichothequeFormatDefBuilder formatDefBuilder, CorpusField corpusField, String patternMode, Attributes attributes) {
        formatDefBuilder.addSource(FormatSourceKey.newFieldKeyInstance(corpusField.getFieldKey()));
        if (BdfColDefs.isWithIntegerCast(corpusField)) {
            formatDefBuilder.setCastType("integer");
        }
        switch (patternMode) {
            case "formsyntax": {
                formatDefBuilder.addFormatPattern("{formsyntax}");
                break;
            }
            case "standard": {
                if (BdfColDefs.isWithSeparator(corpusField)) {
                    BdfColDefs.commonLabel(formatDefBuilder, corpusField, attributes, true);
                    break;
                }
                switch (corpusField.getFicheItemType()) {
                    case "amount": {
                        formatDefBuilder.addFormatPattern("{code}").setCastType("money");
                        break;
                    }
                    case "number": {
                        formatDefBuilder.addFormatPattern("{code}").setCastType("decimal");
                        break;
                    }
                    case "date": {
                        String dateStyle = BdfColDefs.getDateStyle(attributes, "long");
                        formatDefBuilder.addFormatPattern("{code}").setCastType("date").putStringValue("datestyle", dateStyle);
                        break;
                    }
                    case "country": 
                    case "language": {
                        BdfColDefs.commonLabel(formatDefBuilder, corpusField, attributes, false);
                    }
                }
                break;
            }
            case "label": {
                BdfColDefs.commonLabel(formatDefBuilder, corpusField, attributes, BdfColDefs.isWithSeparator(corpusField));
                break;
            }
            case "code": {
                switch (corpusField.getFicheItemType()) {
                    case "amount": 
                    case "number": 
                    case "country": 
                    case "language": {
                        formatDefBuilder.addFormatPattern("{code}");
                    }
                }
            }
        }
        return TableDefUtils.toFormatColDef(corpusField.getFieldString(), formatDefBuilder.toFichothequeFormatDef());
    }

    private static void commonLabel(FichothequeFormatDefBuilder formatDefBuilder, CorpusField corpusField, Attributes attributes, boolean withSeparator) {
        String separator = ", ";
        switch (corpusField.getFicheItemType()) {
            case "amount": {
                separator = " | ";
                formatDefBuilder.addFormatPattern(BdfColDefs.getAmountLabelPattern(attributes));
                break;
            }
            case "number": {
                separator = " | ";
                formatDefBuilder.addFormatPattern("{label}");
                break;
            }
            case "date": {
                separator = " | ";
                formatDefBuilder.addFormatPattern(BdfColDefs.getDateLabelPattern(attributes));
                break;
            }
            case "country": 
            case "language": {
                formatDefBuilder.addFormatPattern("{label}");
            }
        }
        if (withSeparator) {
            formatDefBuilder.putStringValue("sep", separator);
        }
    }

    public static FormatColDef subsetIncludeField(FichothequeFormatDefBuilder formatDefBuilder, ExtendedIncludeKey includeKey, String patternMode, Fichotheque fichotheque, SubsetPathKey masterPath) {
        if (includeKey.isMaster() && masterPath != null) {
            formatDefBuilder.addSource(FormatSourceKey.newIncludeKeyInstance(includeKey.getRootIncludeKey(), masterPath));
        } else {
            formatDefBuilder.addSource(FormatSourceKey.newIncludeKeyInstance(includeKey.getRootIncludeKey()));
        }
        SubsetKey subsetKey = includeKey.getSubsetKey();
        if (subsetKey.isThesaurusSubset()) {
            boolean isIdalpha = BdfColDefs.isIdalpha(fichotheque, subsetKey);
            switch (patternMode) {
                case "standard": 
                case "label": {
                    if (isIdalpha) {
                        formatDefBuilder.addFormatPattern("{idalpha} \u2013 {label}");
                        break;
                    }
                    formatDefBuilder.addFormatPattern("{label}");
                    break;
                }
                case "code": {
                    if (isIdalpha) {
                        formatDefBuilder.addFormatPattern("{idalpha}");
                        break;
                    }
                    formatDefBuilder.addFormatPattern("{id}");
                    break;
                }
                case "formsyntax": {
                    formatDefBuilder.addFormatPattern("{formsyntax}");
                }
            }
        } else if (subsetKey.isCorpusSubset()) {
            switch (patternMode) {
                case "standard": 
                case "label": {
                    formatDefBuilder.addFormatPattern("{title}").putStringValue("sep", ", ");
                    break;
                }
                case "code": {
                    formatDefBuilder.addFormatPattern("{id}");
                    break;
                }
                case "formsyntax": {
                    formatDefBuilder.addFormatPattern("{formsyntax}");
                }
            }
        } else {
            switch (patternMode) {
                case "standard": 
                case "code": 
                case "label": {
                    break;
                }
                case "formsyntax": {
                    formatDefBuilder.addFormatPattern("{formsyntax}");
                }
            }
        }
        return TableDefUtils.toFormatColDef(includeKey.getKeyString(), formatDefBuilder.toFichothequeFormatDef());
    }

    private static boolean isWithSeparator(CorpusField corpusField) {
        switch (corpusField.getCategory()) {
            case 2: {
                return true;
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "owners": {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean isWithIntegerCast(CorpusField corpusField) {
        switch (corpusField.getFieldString()) {
            case "id": {
                return true;
            }
        }
        return false;
    }

    private static boolean isIdalpha(Fichotheque fichotheque, SubsetKey subsetKey) {
        Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(subsetKey);
        if (thesaurus != null) {
            return thesaurus.isIdalphaType();
        }
        return false;
    }

    private static String getAmountLabelPattern(Attributes attributes) {
        StringBuilder buf = new StringBuilder();
        buf.append("{label");
        String amountSubunit = attributes.getFirstValue(FormatSpace.AMOUNTSUBUNIT_KEY);
        if (amountSubunit != null) {
            buf.append(",subunit=");
            buf.append(amountSubunit);
        }
        buf.append("}");
        return buf.toString();
    }

    private static String getDateLabelPattern(Attributes attributes) {
        String dateStyle = BdfColDefs.getDateStyle(attributes, "long");
        StringBuilder buf = new StringBuilder();
        buf.append("{label");
        buf.append(",datestyle=");
        buf.append(dateStyle);
        String truncateType = attributes.getFirstValue(FormatSpace.DATELABELTRUNCATE_KEY);
        if (truncateType != null) {
            try {
                truncateType = FuzzyDate.checkDateType(truncateType);
                buf.append(",truncate=");
                buf.append(truncateType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        buf.append("}");
        return buf.toString();
    }

    private static String getDateStyle(Attributes attributes, String defaultDateStyle) {
        if (attributes == null) {
            return defaultDateStyle;
        }
        String dateStyle = attributes.getFirstValue(FormatSpace.DATESTYLE_KEY);
        if (dateStyle == null) {
            return defaultDateStyle;
        }
        try {
            return FormatConstants.checkDateStyle(dateStyle);
        }
        catch (IllegalArgumentException iae) {
            return defaultDateStyle;
        }
    }
}

