/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.central;

import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralUserEditor;
import fr.exemole.bdfserver.multi.commands.central.AbstractCentralMultiCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CopyFromFichothequeCommand
extends AbstractCentralMultiCommand {
    public static final String COMMAND_NAME = "CopyFromFichotheque";
    public static final String LOGINS_PARAMNAME = "logins";

    public CopyFromFichothequeCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        Set<String> loginSet = this.getLoginSet();
        this.initCentralSphere();
        this.initBdfServer(true);
        this.initCentralEditors();
        CentralSphere centralSphere = this.getCentralSphere();
        synchronized (centralSphere) {
            this.copy(loginSet);
            this.saveChanges();
        }
        return this.done("_ done.multi.copyfromfichotheque");
    }

    private void copy(Set<String> loginSet) {
        Sphere sphere = (Sphere)this.bdfServer.getFichotheque().getSubset(this.centralSphere.getSphereKey());
        for (Redacteur redacteur : sphere.getRedacteurList()) {
            String login = redacteur.getLogin();
            if (!loginSet.contains(login) || this.centralSphere.hasCentralUser(login)) continue;
            this.createCentralUser(redacteur, login);
        }
    }

    private void createCentralUser(Redacteur redacteur, String login) {
        CentralUserEditor centralUserEditor = this.centralSphereEditor.createCentralUser(login);
        centralUserEditor.setStatus(redacteur.getStatus());
        centralUserEditor.setPerson(redacteur.getPersonCore());
        centralUserEditor.setEmail(redacteur.getEmailCore());
        centralUserEditor.setEncryptedPassword(this.bdfServer.getPasswordManager().getEncryptedPassword(redacteur.getGlobalId()));
        BdfUser bdfUser = this.bdfServer.createBdfUser(redacteur);
        centralUserEditor.setLangContext(bdfUser.getWorkingLang(), bdfUser.getPrefs().getCustomFormatLocale(), bdfUser.getPrefs().getCustomLangPreference());
    }

    private Set<String> getLoginSet() throws ErrorMessageException {
        String[] logins = this.requestMap.getParameterTokens(LOGINS_PARAMNAME, true);
        if (logins == null) {
            throw BdfErrors.emptyMandatoryParameter(LOGINS_PARAMNAME);
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String login : logins) {
            set.add(login);
        }
        return set;
    }
}

