/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.managers.TreeManager;
import fr.exemole.bdfserver.api.storage.TreeStorage;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.tools.subsettree.SubsetNodeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.FichothequeListener;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;

class TreeManagerImpl
implements TreeManager,
FichothequeListener {
    private final Fichotheque fichotheque;
    private final TreeStorage treeStorage;
    private final Map<Short, InternalSubsetTree> subsetTreeMap = new HashMap<Short, InternalSubsetTree>();

    private TreeManagerImpl(Fichotheque fichotheque, TreeStorage treeStorage) {
        this.fichotheque = fichotheque;
        this.treeStorage = treeStorage;
    }

    static TreeManagerImpl build(Fichotheque fichotheque, TreeStorage treeStorage, Map<Short, SubsetTree> treeMap) {
        TreeManagerImpl impl = new TreeManagerImpl(fichotheque, treeStorage);
        impl.updateSubsetTree((short)1, treeMap);
        impl.updateSubsetTree((short)2, treeMap);
        impl.updateSubsetTree((short)3, treeMap);
        impl.updateSubsetTree((short)5, treeMap);
        impl.updateSubsetTree((short)4, treeMap);
        return impl;
    }

    @Override
    public SubsetTree getSubsetTree(short subsetCategory) {
        return this.subsetTreeMap.get(subsetCategory);
    }

    @Override
    public void subsetCreated(FichothequeEditor fichothequeEditor, Subset subset) {
        SubsetKey subsetKey = subset.getSubsetKey();
        short subsetCategory = subsetKey.getCategory();
        InternalSubsetTree subsetTree = this.subsetTreeMap.get(subsetCategory);
        subsetTree.addNode(SubsetNodeBuilder.build(subsetKey));
        this.treeStorage.saveSubsetTree(subsetCategory, subsetTree);
    }

    @Override
    public void subsetRemoved(FichothequeEditor fichothequeEditor, SubsetKey subsetKey, Subset masterSubset) {
        short subsetCategory = subsetKey.getCategory();
        InternalSubsetTree subsetTree = this.subsetTreeMap.get(subsetCategory);
        boolean done = subsetTree.removeSubset(subsetKey);
        if (done) {
            this.treeStorage.saveSubsetTree(subsetCategory, subsetTree);
        }
    }

    @Override
    public void corpusFieldCreated(FichothequeEditor fichothequeEditor, Corpus corpus, CorpusField corpusField) {
    }

    @Override
    public void corpusFieldRemoved(FichothequeEditor fichothequeEditor, Corpus corpus, FieldKey fieldKey) {
    }

    @Override
    public void subsetItemCreated(FichothequeEditor fichothequeEditor, SubsetItem subsetItem) {
    }

    @Override
    public void ficheSaved(FichothequeEditor fichothequeEditor, FicheMeta ficheMeta, FicheAPI fiche) {
    }

    @Override
    public void subsetItemRemoved(FichothequeEditor fichothequeEditor, Subset subset, int id) {
    }

    private void updateSubsetTree(short subsetCategory, Map<Short, SubsetTree> treeMap) {
        this.updateSubsetTree(subsetCategory, treeMap.get(subsetCategory));
    }

    void updateSubsetTree(short subsetCategory, SubsetTree originalSubsetTree) {
        SortedSet<SubsetKey> existingSubsetSet = TreeManagerImpl.getExistingSubsetSet(subsetCategory, this.fichotheque);
        TreeChecker treeChecker = new TreeChecker(subsetCategory, existingSubsetSet);
        InternalSubsetTree internalSubsetTree = this.subsetTreeMap.get(subsetCategory);
        if (internalSubsetTree == null) {
            internalSubsetTree = new InternalSubsetTree(subsetCategory);
            this.subsetTreeMap.put(subsetCategory, internalSubsetTree);
        } else {
            internalSubsetTree.clear();
        }
        if (originalSubsetTree != null) {
            for (SubsetTree.Node node : originalSubsetTree.getNodeList()) {
                InternalGroupNode groupNode;
                if (node instanceof SubsetNode) {
                    SubsetKey subsetKey = ((SubsetNode)node).getSubsetKey();
                    if (!treeChecker.check(subsetKey)) continue;
                    internalSubsetTree.addNode(SubsetNodeBuilder.build(subsetKey));
                    continue;
                }
                if (!(node instanceof GroupNode) || (groupNode = this.buildGroupNode((GroupNode)node, treeChecker, internalSubsetTree)) == null) continue;
                internalSubsetTree.addNode(groupNode);
            }
        }
        treeChecker.endCheck(internalSubsetTree);
    }

    void saveSubsetTree(short subsetCategory) {
        InternalSubsetTree subsetTree = this.subsetTreeMap.get(subsetCategory);
        if (subsetTree != null) {
            this.treeStorage.saveSubsetTree(subsetCategory, subsetTree);
        }
    }

    private InternalGroupNode buildGroupNode(GroupNode groupNode, TreeChecker treeChecker, NodeConsumer currentConsumer) {
        String groupName = groupNode.getName();
        InternalGroupNode ign = null;
        if (treeChecker.check(groupName)) {
            ign = new InternalGroupNode(groupName);
            currentConsumer = ign;
        }
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            InternalGroupNode child;
            if (subnode instanceof SubsetNode) {
                SubsetKey subsetKey = ((SubsetNode)subnode).getSubsetKey();
                if (!treeChecker.check(subsetKey)) continue;
                currentConsumer.addNode(SubsetNodeBuilder.build(subsetKey));
                continue;
            }
            if (!(subnode instanceof GroupNode) || (child = this.buildGroupNode((GroupNode)subnode, treeChecker, currentConsumer)) == null) continue;
            currentConsumer.addNode(child);
        }
        return ign;
    }

    private static SortedSet<SubsetKey> getExistingSubsetSet(short subsetCategory, Fichotheque fichotheque) {
        TreeSet<SubsetKey> existingSubsetSet;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            existingSubsetSet = new TreeSet<SubsetKey>();
                            if (subsetCategory != 1) break block5;
                            for (Corpus corpus : fichotheque.getCorpusList()) {
                                existingSubsetSet.add(corpus.getSubsetKey());
                            }
                            break block6;
                        }
                        if (subsetCategory != 2) break block7;
                        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
                            existingSubsetSet.add(thesaurus.getSubsetKey());
                        }
                        break block6;
                    }
                    if (subsetCategory != 3) break block8;
                    for (Sphere sphere : fichotheque.getSphereList()) {
                        existingSubsetSet.add(sphere.getSubsetKey());
                    }
                    break block6;
                }
                if (subsetCategory != 5) break block9;
                for (Album album : fichotheque.getAlbumList()) {
                    existingSubsetSet.add(album.getSubsetKey());
                }
                break block6;
            }
            if (subsetCategory != 4) break block6;
            for (Addenda addenda : fichotheque.getAddendaList()) {
                existingSubsetSet.add(addenda.getSubsetKey());
            }
        }
        return existingSubsetSet;
    }

    private static class InternalSubsetTree
    extends NodeConsumer
    implements SubsetTree {
        private final List<SubsetTree.Node> nodeList = new ArrayList<SubsetTree.Node>();
        private final List<SubsetTree.Node> unmodifiableNodeList = Collections.unmodifiableList(this.nodeList);
        private final short subsetCategory;

        private InternalSubsetTree(short subsetCategory) {
            this.subsetCategory = subsetCategory;
        }

        @Override
        public List<SubsetTree.Node> getNodeList() {
            return this.unmodifiableNodeList;
        }

        @Override
        void addNode(SubsetTree.Node node) {
            this.nodeList.add(node);
        }

        private void clear() {
            this.nodeList.clear();
        }

        private boolean removeSubset(SubsetKey subsetKey) {
            int length = this.nodeList.size();
            for (int i = 0; i < length; ++i) {
                boolean done;
                SubsetTree.Node node = this.nodeList.get(i);
                if (node instanceof SubsetNode) {
                    if (!((SubsetNode)node).getSubsetKey().equals(subsetKey)) continue;
                    this.nodeList.remove(i);
                    return true;
                }
                if (!(node instanceof GroupNode) || !(done = ((InternalGroupNode)node).removeSubset(subsetKey))) continue;
                return true;
            }
            return false;
        }
    }

    private static class TreeChecker {
        private final short subsetCategory;
        private final SortedSet<SubsetKey> existingSubsetSet;
        private final Set<String> groupNameSet = new HashSet<String>();

        private TreeChecker(short subsetCategory, SortedSet<SubsetKey> existingSubsetSet) {
            this.subsetCategory = subsetCategory;
            this.existingSubsetSet = existingSubsetSet;
        }

        private boolean check(String groupName) {
            if (this.groupNameSet.contains(groupName)) {
                return false;
            }
            this.groupNameSet.add(groupName);
            return true;
        }

        private boolean check(SubsetKey subsetKey) {
            if (subsetKey.getCategory() != this.subsetCategory) {
                return false;
            }
            if (!this.existingSubsetSet.contains(subsetKey)) {
                return false;
            }
            this.existingSubsetSet.remove(subsetKey);
            return true;
        }

        private void endCheck(InternalSubsetTree subsetTree) {
            for (SubsetKey subsetKey : this.existingSubsetSet) {
                subsetTree.addNode(SubsetNodeBuilder.build(subsetKey));
            }
        }
    }

    private static abstract class NodeConsumer {
        private NodeConsumer() {
        }

        abstract void addNode(SubsetTree.Node var1);
    }

    private static class InternalGroupNode
    extends NodeConsumer
    implements GroupNode {
        private final List<SubsetTree.Node> subnodeList = new ArrayList<SubsetTree.Node>();
        private final List<SubsetTree.Node> unmodifiableSubnodeList = Collections.unmodifiableList(this.subnodeList);
        private final String name;

        private InternalGroupNode(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<SubsetTree.Node> getSubnodeList() {
            return this.unmodifiableSubnodeList;
        }

        @Override
        void addNode(SubsetTree.Node node) {
            this.subnodeList.add(node);
        }

        private void clear() {
            this.subnodeList.clear();
        }

        private boolean removeSubset(SubsetKey subsetKey) {
            int length = this.subnodeList.size();
            for (int i = 0; i < length; ++i) {
                boolean done;
                SubsetTree.Node subnode = this.subnodeList.get(i);
                if (subnode instanceof SubsetNode) {
                    if (!((SubsetNode)subnode).getSubsetKey().equals(subsetKey)) continue;
                    this.subnodeList.remove(i);
                    return true;
                }
                if (!(subnode instanceof GroupNode) || !(done = ((InternalGroupNode)subnode).removeSubset(subsetKey))) continue;
                return true;
            }
            return false;
        }
    }
}

