/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.uml.CorpusPumlWriter;
import fr.exemole.bdfserver.tools.uml.FichothequePumlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;

public class PumlProducer
implements StreamProducer {
    private final BdfServer bdfServer;
    private final Lang lang;
    private final MessageLocalisation messageLocalisation;
    private final Corpus corpus;

    public PumlProducer(BdfServer bdfServer, BdfUser bdfUser, @Nullable Corpus corpus) {
        this.bdfServer = bdfServer;
        this.lang = bdfUser.getWorkingLang();
        this.messageLocalisation = bdfServer.getL10nManager().getMessageLocalisation(bdfUser);
        this.corpus = corpus;
    }

    @Override
    public String getMimeType() {
        return "text/plain";
    }

    @Override
    public String getCharset() {
        return "UTF-8";
    }

    @Override
    public String getFileName() {
        return null;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");){
            if (this.corpus == null) {
                FichothequePumlWriter pumlWriter = new FichothequePumlWriter(this.bdfServer, this.lang, this.messageLocalisation);
                pumlWriter.write(writer);
            } else {
                CorpusPumlWriter pumlWriter = new CorpusPumlWriter(this.bdfServer, this.lang, this.messageLocalisation, this.corpus);
                pumlWriter.write(writer);
            }
        }
    }
}

