/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.exportation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class TableExportContentChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "TableExportContentChange";
    public static final String COMMANDKEY = "_ EXP-17";
    public static final String CONTENT_PARAMNAME = "content";
    private String tableExportName;
    private String contentPath;
    private String content;

    public TableExportContentChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        TableExportDescription tableExportDescription;
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("exportation", COMMANDNAME);
        try (InputStream is = IOUtils.toInputStream(this.content, "UTF-8");){
            tableExportDescription = this.bdfServer.getTableExportManager().putTableExportContent(this.tableExportName, this.contentPath, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.tableexportcontent_io", ioe.getMessage());
        }
        if (tableExportDescription != null) {
            this.putResultObject("obj.tableexportdescription", tableExportDescription);
            this.setDone("_ done.exportation.tableexportcontentchange", this.tableExportName, this.contentPath);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        TableExportDescription tableExportDescription = this.requestHandler.getMandatoryTableExportDescription();
        if (!tableExportDescription.isEditable()) {
            throw BdfErrors.unsupportedNotEditableParameterValue("tableexport", tableExportDescription.getName());
        }
        this.tableExportName = tableExportDescription.getName();
        this.contentPath = this.requestHandler.getMandatoryPath();
        if (!TableExportUtils.isContentEditable(tableExportDescription, this.contentPath)) {
            throw BdfErrors.unsupportedNotEditableParameterValue("path", this.contentPath);
        }
        this.content = this.getMandatory(CONTENT_PARAMNAME);
    }
}

