/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.manuel;

import fr.exemole.bdfext.manuel.html.AjoutSouschapitreHtmlProducer;
import fr.exemole.bdfext.manuel.html.ArboHtmlProducer;
import fr.exemole.bdfext.manuel.html.CadreHtmlProducer;
import fr.exemole.bdfext.manuel.html.MenuHtmlProducer;
import fr.exemole.bdfext.manuel.html.ModifLibHtmlProducer;
import fr.exemole.bdfext.manuel.html.ModifListeChapitreHtmlProducer;
import fr.exemole.bdfext.manuel.html.ModifListeSouschapitreHtmlProducer;
import fr.exemole.bdfext.manuel.instructions.ThesaurusCommands;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.Map;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.StringUtils;

public class ManuelBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private final Map<String, String> paramMap;
    private final RequestMap requestMap;
    private final BdfServer bdfServer;
    private HtmlProducer htmlProducer;
    private JsonProducer jsonProducer;

    public ManuelBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> paramMap) {
        this.paramMap = paramMap;
        this.requestMap = requestMap;
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        String pageParam = this.paramMap.get("page");
        if (pageParam.equals("cadre")) {
            this.htmlProducer = new CadreHtmlProducer();
        } else if (pageParam.equals("arbo")) {
            String cmd = this.requestMap.getParameter("cmd");
            if (cmd != null) {
                this.runThesaurusCommand(cmd, bdfUser);
            }
            this.htmlProducer = new ArboHtmlProducer(this.bdfServer);
        } else if (pageParam.equals("modiflistechapitre")) {
            this.htmlProducer = new ModifListeChapitreHtmlProducer(this.bdfServer);
        } else if (pageParam.equals("modiflib")) {
            Motcle motcle = this.getMotcle();
            if (motcle == null) {
                return null;
            }
            this.htmlProducer = new ModifLibHtmlProducer(this.bdfServer, motcle);
        } else if (pageParam.equals("ajoutsouschapitre")) {
            Motcle motcle = this.getMotcle();
            if (motcle == null) {
                return null;
            }
            this.htmlProducer = new AjoutSouschapitreHtmlProducer(this.bdfServer, motcle);
        } else if (pageParam.equals("modiflistesouschapitre")) {
            Motcle motcle = this.getMotcle();
            if (motcle == null) {
                return null;
            }
            this.htmlProducer = new ModifListeSouschapitreHtmlProducer(this.bdfServer, motcle);
        } else {
            if (pageParam.equals("action")) {
                String cmd = this.requestMap.getParameter("cmd");
                String message = this.runThesaurusCommand(cmd, bdfUser);
                if (message == null) {
                    return SimpleResponseHandler.init((String)("Erreur interne : param\u00e8tres manquants pour la commande = " + cmd));
                }
                return this.getResponsePrinter(message);
            }
            if (pageParam.equals("menu")) {
                this.htmlProducer = new MenuHtmlProducer(this.bdfServer);
            } else if (pageParam.equals("saisie")) {
                return SimpleResponseHandler.init((String)"");
            }
        }
        if (this.htmlProducer != null) {
            return HtmlResponseHandler.init((HtmlProducer)this.htmlProducer);
        }
        if (this.jsonProducer != null) {
            return JsonResponseHandler.build((JsonProducer)this.jsonProducer, (RequestMap)this.requestMap);
        }
        return SimpleResponseHandler.init((String)"Erreur interne : ni htmlProducer, ni jsonProducer ne sont d\u00e9finis");
    }

    private String runThesaurusCommand(String cmd, BdfUser bdfUser) {
        ThesaurusCommands commands = new ThesaurusCommands(this.bdfServer, bdfUser);
        if (cmd.equals("nvchapitre")) {
            String nvlib = this.requestMap.getParameter("lib");
            CleanedString cleanedString = CleanedString.newInstance((CharSequence)nvlib);
            if (cleanedString == null) {
                return null;
            }
            commands.addNouveauChapitre(cleanedString);
        } else {
            if (cmd.equals("listechapitre")) {
                String liste = this.requestMap.getParameter("liste");
                String[] tokens = StringUtils.getLineTokens((String)liste, (short)2);
                commands.changeChapitreOrder(tokens);
                return "Liste des chapitres modifi\u00e9es";
            }
            if (cmd.equals("lib")) {
                String lib = this.requestMap.getParameter("lib");
                try {
                    int motcleid = Integer.parseInt(this.requestMap.getParameter("id"));
                    CleanedString cleanedString = CleanedString.newInstance((CharSequence)lib);
                    commands.changeLibelle(motcleid, cleanedString);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                return "Libell\u00e9 modifi\u00e9";
            }
            if (cmd.equals("ajoutsouschapitre")) {
                String lib = this.requestMap.getParameter("lib");
                CleanedString cleanedString = CleanedString.newInstance((CharSequence)lib);
                try {
                    int motcleid = Integer.parseInt(this.requestMap.getParameter("id"));
                    commands.ajoutSouschapitre(motcleid, cleanedString);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                return "Sous-chapitre ajout\u00e9";
            }
            if (cmd.equals("listesouschapitre")) {
                try {
                    int id = Integer.parseInt(this.requestMap.getParameter("id"));
                    String liste = this.requestMap.getParameter("liste");
                    String[] tokens = StringUtils.getLineTokens((String)liste, (short)2);
                    commands.changeSouschapitreOrder(id, tokens);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                return "Liste des sous-chapitres modifi\u00e9es";
            }
        }
        return null;
    }

    private ResponseHandler getResponsePrinter(String message) {
        StringBuilder buf = new StringBuilder();
        buf.append("<html><body><p>");
        buf.append(message);
        buf.append("</p><p><a href=\"Arbo\" target=\"ManuelListe\">Mettre \u00e0 jour la liste</a></p>");
        buf.append("</body></html>");
        return SimpleResponseHandler.init((String)buf.toString(), (String)"text/html");
    }

    private Motcle getMotcle() {
        Thesaurus thesaurus = this.bdfServer.getFichotheque().getThesaurus("chapitre");
        try {
            int motcleid = Integer.parseInt(this.paramMap.get("id"));
            return thesaurus.getMotcleById(motcleid);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

