/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinterUtils;
import fr.exemole.bdfext.cef.htmlpages.CefUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;

public class PersonneAtelierParFonction {
    private final Fichotheque fichotheque;
    private final Motcle fonction;
    private final List<FicheMeta> confirmeList = new ArrayList<FicheMeta>();
    private final List<FicheMeta> contactList = new ArrayList<FicheMeta>();
    private final List<FicheMeta> envisageList = new ArrayList<FicheMeta>();
    private final Corpus personneCorpus;

    PersonneAtelierParFonction(Motcle fonction) {
        this.fichotheque = fonction.getFichotheque();
        this.fonction = fonction;
        this.personneCorpus = this.fichotheque.getCorpus("personne");
    }

    public void add(int weight, FicheMeta personneAtelier) {
        this.getPersonneAtelierList(weight).add(personneAtelier);
    }

    public List<FicheMeta> getPersonneAtelierList(int weight) {
        switch (weight) {
            case 8: {
                return this.confirmeList;
            }
            case 5: {
                return this.contactList;
            }
            case 3: {
                return this.envisageList;
            }
        }
        return null;
    }

    public Motcle getFonction() {
        return this.fonction;
    }

    public void printLists(HtmlPrinter hp) {
        this.printList(8, hp);
        this.printList(5, hp);
        this.printList(3, hp);
    }

    void printList(int weight, HtmlPrinter hp) {
        List<FicheMeta> list = this.getPersonneAtelierList(weight);
        int size = list.size();
        if (size == 0) {
            return;
        }
        hp.LI("FONCTION_POIDS_" + weight);
        hp.DIV().__localize("fonction_poids_" + weight).__space().__escape('(').__escape((CharSequence)CefUtils.getStatut(weight)).__escape(')')._DIV();
        hp.UL();
        for (FicheMeta ficheMeta : list) {
            hp.LI();
            hp.DIV();
            String titre = ficheMeta.getTitle();
            int idx = titre.indexOf(47);
            hp.__escape((CharSequence)titre.substring(idx + 1).trim());
            hp._DIV();
            hp.UL();
            hp.LI("LIEN_SAISIE");
            hp.__localize("fiche_personneatelier").__colon().__space();
            CefHtmlPrinterUtils.printLienFiche(hp, "personneatelier2010", ficheMeta.getId());
            hp._LI();
            Junctions personneJunctions = this.fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)this.personneCorpus);
            if (!personneJunctions.isEmpty()) {
                hp.LI("LIEN_SAISIE");
                hp.__localize("fiche_personne").__colon().__space();
                CefHtmlPrinterUtils.printLienFiche(hp, "personne", personneJunctions.getFirstSubsetItem().getId());
                hp._LI();
            }
            hp._UL();
            hp._LI();
        }
        hp._UL();
        hp._LI();
    }

    public void printSimpleLists(HtmlPrinter hp) {
        this.printSimpleList(8, hp);
        this.printSimpleList(5, hp);
        this.printSimpleList(3, hp);
    }

    void printSimpleList(int weight, HtmlPrinter hp) {
        List<FicheMeta> list = this.getPersonneAtelierList(weight);
        int size = list.size();
        if (size == 0) {
            return;
        }
        hp.LI("FONCTION_POIDS_" + weight);
        hp.DIV().__localize("fonction_poids_" + weight).__space().__escape('(').__escape((CharSequence)CefUtils.getStatut(weight)).__escape(')')._DIV();
        hp.UL();
        for (FicheMeta ficheMeta : list) {
            hp.LI();
            Junctions personneJunctions = this.fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)this.personneCorpus);
            FicheMeta personne = (FicheMeta)personneJunctions.getFirstSubsetItem();
            if (personne != null) {
                hp.A(HA.href((CharSequence)("../../fiches/personne-" + personne.getId() + ".html"))).__escape((CharSequence)personne.getTitle())._A();
            }
            hp._LI();
        }
        hp._UL();
        hp._LI();
    }
}

