/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.primitives.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.mapeadores.util.primitives.PrimUtils;
import net.mapeadores.util.primitives.io.DataInputPrimitivesReader;

public class RandomAccessPrimitivesReader
extends DataInputPrimitivesReader {
    private final RandomAccessFile randomAccessFile;
    private final byte[] intBuffer = new byte[4];
    private final byte[] longBuffer = new byte[8];

    public RandomAccessPrimitivesReader(RandomAccessFile randomAccessFile) {
        super(randomAccessFile);
        this.randomAccessFile = randomAccessFile;
    }

    @Override
    public int readInt() throws IOException {
        int length = this.randomAccessFile.read(this.intBuffer, 0, 4);
        if (length != 4) {
            throw new EOFException();
        }
        return PrimUtils.toInt(this.intBuffer);
    }

    @Override
    public long readLong() throws IOException {
        int length = this.randomAccessFile.read(this.longBuffer, 0, 8);
        if (length != 8) {
            throw new EOFException();
        }
        return PrimUtils.toLong(this.longBuffer);
    }

    @Override
    public void read(byte[] buffer, int offset, int length) throws IOException {
        int result = this.randomAccessFile.read(buffer, offset, length);
        if (result != length) {
            throw new EOFException();
        }
    }
}

