/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.ini.IniParser;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.localisation.LangScript;
import net.mapeadores.util.text.StringUtils;

public final class Lang
implements Serializable,
Comparable<Lang> {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Lang> langMap = new HashMap<String, Lang>();
    private static final Map<String, String> conversionMap = new HashMap<String, String>();
    private final String code;
    private final Locale locale;
    private final Lang rootLang;
    private final Country region;
    private final LangScript script;
    private final String[] variantArray;

    private Lang(String rootCode) {
        this.code = rootCode;
        this.rootLang = null;
        this.locale = new Locale(rootCode);
        this.region = null;
        this.script = null;
        this.variantArray = null;
    }

    private Lang(String code, Lang rootLang, Options options) {
        this.code = code;
        this.rootLang = rootLang;
        this.region = options.region;
        this.script = options.script;
        this.locale = this.region != null ? new Locale(rootLang.toString(), this.region.toString()) : new Locale(rootLang.toString());
        this.variantArray = options.getVariantArray();
    }

    public Country getRegion() {
        return this.region;
    }

    public LangScript getScript() {
        return this.script;
    }

    public int getVariantCount() {
        if (this.variantArray == null) {
            return 0;
        }
        return this.variantArray.length;
    }

    public String getVariant(int index) {
        if (this.variantArray == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.variantArray[index];
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Lang otherLang = (Lang)other;
        return otherLang.code.equals(this.code);
    }

    public String toString() {
        return this.code;
    }

    @Override
    public int compareTo(Lang otherLang) {
        return this.code.compareTo(otherLang.code);
    }

    public Locale toLocale() {
        return this.locale;
    }

    public boolean isRootLang() {
        return this.rootLang == null;
    }

    public Lang getRootLang() {
        if (this.rootLang == null) {
            return this;
        }
        return this.rootLang;
    }

    public boolean isRTLScript() {
        if (this.script != null) {
            return this.script.isRTLScript();
        }
        if (this.rootLang != null) {
            return this.rootLang.isRTLScript();
        }
        if (this.code.equals("ar")) {
            return true;
        }
        return this.code.equals("he");
    }

    public static Lang build(String langCode) {
        try {
            return Lang.parse(langCode);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lang parse(String langCode) throws ParseException {
        if (langCode == null) {
            throw new ParseException("null", 0);
        }
        Lang lang = langMap.get(langCode);
        if (lang != null) {
            return lang;
        }
        Map<String, Lang> map = langMap;
        synchronized (map) {
            langCode = langCode.toLowerCase();
            lang = langMap.get(langCode);
            if (lang != null) {
                return lang;
            }
            int length = langCode.length();
            if (length == 0) {
                throw new ParseException("empty string", 0);
            }
            if (length == 1) {
                throw new ParseException("too short string", 0);
            }
            if (length == 2 || length == 3) {
                lang = Lang.parseRootLang(langCode);
            } else {
                int idx = langCode.indexOf(45);
                if (idx == -1) {
                    throw new ParseException("too long String", langCode.length() - 1);
                }
                if (idx != 2 && idx != 3) {
                    throw new ParseException("bad - position", idx);
                }
                String rootLangString = langCode.substring(0, idx).toLowerCase();
                Lang rootLang = langMap.get(rootLangString);
                if (rootLang == null) {
                    rootLang = Lang.parseRootLang(rootLangString);
                }
                Options options = Lang.parseOptions(langCode.substring(idx + 1));
                langCode = rootLang.toString() + options.toString();
                lang = new Lang(langCode, rootLang, options);
                langMap.put(langCode, lang);
            }
        }
        return lang;
    }

    public static Lang getDefault() {
        try {
            return Lang.fromLocale(Locale.getDefault());
        }
        catch (ParseException pe) {
            return Lang.build("en");
        }
    }

    public static Lang fromLocale(Locale locale) throws ParseException {
        String country;
        String language = locale.getLanguage();
        if (language.length() == 0) {
            language = "und";
        }
        if ((country = locale.getCountry()).length() > 0) {
            language = language + "-" + country;
        }
        return Lang.parse(language);
    }

    public static String toISOString(Locale locale) {
        try {
            return Lang.fromLocale(locale).toString();
        }
        catch (ParseException pe) {
            return locale.toString().replace('_', '-');
        }
    }

    private static Lang parseRootLang(String langCode) throws ParseException {
        Lang lang;
        if (!Lang.testChar(langCode.charAt(0))) {
            throw new ParseException("wrong char: " + langCode.charAt(0), 0);
        }
        if (!Lang.testChar(langCode.charAt(1))) {
            throw new ParseException("wrong char: " + langCode.charAt(1), 1);
        }
        if (langCode.length() == 3 && !Lang.testChar(langCode.charAt(2))) {
            throw new ParseException("wrong char: " + langCode.charAt(2), 2);
        }
        String conversion = conversionMap.get(langCode);
        if (conversion != null) {
            lang = langMap.get(conversion);
            if (lang == null) {
                lang = new Lang(conversion);
                langMap.put(conversion, lang);
            }
        } else {
            lang = new Lang(langCode);
        }
        langMap.put(langCode, lang);
        return lang;
    }

    private static boolean testChar(char carac) {
        return carac >= 'a' && carac <= 'z';
    }

    private static boolean testVariantChar(char carac) {
        if (carac >= 'a' && carac <= 'z') {
            return true;
        }
        return carac >= '0' && carac <= '9';
    }

    private static Options parseOptions(String optionsString) throws ParseException {
        String[] tokens = StringUtils.getTokens(optionsString, '-', (short)0);
        int length = tokens.length;
        if (length == 0) {
            throw new ParseException("empty options ", 0);
        }
        Options options = new Options();
        options.parseFirstToken(tokens[0]);
        if (length > 1) {
            options.parseFirstToken(tokens[1]);
        }
        if (length > 2) {
            for (int i = 2; i < length; ++i) {
                options.parseSupplementaryToken(tokens[i]);
            }
        }
        return options;
    }

    private static void checkVariant(String variant) throws ParseException {
        char carac;
        int length = variant.length();
        if (length < 4) {
            throw new ParseException("Too short variant: " + variant, 0);
        }
        if (length > 8) {
            throw new ParseException("Too long variant: " + variant, 0);
        }
        if (length == 4 && ((carac = variant.charAt(0)) < '0' || carac > '9')) {
            throw new ParseException("Variant of length = 4 must start with a digit: " + variant, 0);
        }
        for (int i = 0; i < length; ++i) {
            char carac2 = variant.charAt(i);
            if (Lang.testVariantChar(carac2)) continue;
            throw new ParseException("Invalid character (" + carac2 + ") in variant: " + variant, i);
        }
    }

    static {
        try (InputStream langConversionStream = Country.class.getResourceAsStream("conversion_lang.ini");){
            IniParser.parseIni(langConversionStream, conversionMap);
        }
        catch (IOException ioe) {
            throw new InternalResourceException(ioe);
        }
    }

    private static class Options {
        private Country region;
        private LangScript script;
        private final Set<String> variantSet = new LinkedHashSet<String>();

        private Options() {
        }

        private void parseFirstToken(String token) throws ParseException {
            int length = token.length();
            if (length == 0) {
                throw new ParseException("empty token", 0);
            }
            if (length > 8) {
                throw new ParseException("too long token: " + token, 0);
            }
            if (length == 1) {
                throw new ParseException("too short token: " + token, 0);
            }
            if (length == 3) {
                throw new ParseException("too short token: " + token, 0);
            }
            if (length == 4) {
                try {
                    this.script = LangScript.parse(token);
                }
                catch (ParseException pe) {
                    Lang.checkVariant(token);
                    this.variantSet.add(token);
                }
            } else if (length == 2) {
                try {
                    this.region = Country.parse(token);
                }
                catch (ParseException pe) {
                    throw new ParseException("wrong region token: " + token, 0);
                }
            } else {
                Lang.checkVariant(token);
                this.variantSet.add(token);
            }
        }

        private void parseSupplementaryToken(String token) throws ParseException {
            Lang.checkVariant(token);
            if (this.variantSet.contains(token)) {
                throw new ParseException("variant defined twice: " + token, 0);
            }
            this.variantSet.add(token);
        }

        private String[] getVariantArray() {
            if (this.variantSet.isEmpty()) {
                return null;
            }
            return this.variantSet.toArray(new String[this.variantSet.size()]);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.script != null) {
                buf.append('-');
                buf.append(this.script.toString());
            }
            if (this.region != null) {
                buf.append('-');
                buf.append(this.region.toString());
            }
            for (String variant : this.variantSet) {
                buf.append('-');
                buf.append(variant);
            }
            return buf.toString();
        }
    }
}

