/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.io.docstream;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.mimetype.MimeTypeUtils;

public class ClassResourceDocStream
implements DocStream {
    private static long lastModified;
    private Class referenceClass;
    private String resourcePath;
    private String mimeType = "application/octet-stream";
    private String charset = null;
    private int length = -1;

    private ClassResourceDocStream(Class referenceClass, String resourcePath) {
        this.referenceClass = referenceClass;
        this.resourcePath = resourcePath;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.referenceClass.getResourceAsStream(this.resourcePath);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        this.charset = MimeTypeUtils.getDefaultCharset(mimeType);
    }

    public void setMimeType(String mimeType, String charset) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
        this.charset = charset;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public long getLastModified() {
        return lastModified;
    }

    public static ClassResourceDocStream newInstance(Class referenceClass, String resourcePath) {
        String fileName = resourcePath;
        int idx = resourcePath.lastIndexOf("/");
        if (idx != -1) {
            fileName = resourcePath.substring(idx + 1);
        }
        if (fileName.indexOf(".") == -1) {
            return null;
        }
        URL url = referenceClass.getResource(resourcePath);
        if (url == null) {
            return null;
        }
        return new ClassResourceDocStream(referenceClass, resourcePath);
    }

    static {
        long l = System.currentTimeMillis();
        lastModified = (l /= 1000L) * 1000L;
    }
}

