/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.hook;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.hook.HookHandler;

public class MultiHookHandlerBuilder {
    private List<HookHandler> handlerList = new ArrayList<HookHandler>();

    public MultiHookHandlerBuilder addHookHandler(HookHandler hookHandler) {
        if (hookHandler != null) {
            this.handlerList.add(hookHandler);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.handlerList.isEmpty();
    }

    public HookHandler toHookHandler() {
        return new MultiHookHandler(this.handlerList.toArray(new HookHandler[this.handlerList.size()]));
    }

    public static MultiHookHandlerBuilder init() {
        return new MultiHookHandlerBuilder();
    }

    private static class MultiHookHandler
    implements HookHandler {
        private final HookHandler[] array;

        private MultiHookHandler(HookHandler[] array) {
            this.array = array;
        }

        @Override
        public void handle(String hookName, Object ... arguments) {
            for (HookHandler hookHandler : this.array) {
                hookHandler.handle(hookName, arguments);
            }
        }
    }
}

