/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuffer;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.CleanedString;

public class AttributesBuilder
implements AttributeBuffer {
    private final SortedMap<AttributeKey, AttributeBuilder> attributeBuilderMap = new TreeMap<AttributeKey, AttributeBuilder>();

    public AttributesBuilder() {
    }

    public AttributesBuilder(@Nullable Attributes initAttributes) {
        if (initAttributes != null) {
            for (Attribute attribute : initAttributes) {
                this.put(attribute);
            }
        }
    }

    public boolean containsValue(AttributeKey attributeKey) {
        AttributeBuilder builder = (AttributeBuilder)this.attributeBuilderMap.get(attributeKey);
        if (builder == null) {
            return false;
        }
        return !builder.isEmpty();
    }

    @Override
    public AttributesBuilder appendValue(AttributeKey attributeKey, String value) {
        return (AttributesBuilder)AttributeBuffer.super.appendValue(attributeKey, value);
    }

    @Override
    public AttributesBuilder appendValue(AttributeKey attributeKey, CleanedString cleanedString) {
        if (cleanedString == null) {
            return this;
        }
        AttributeBuilder builder = this.getOrCreate(attributeKey);
        builder.addValue(cleanedString);
        return this;
    }

    public AttributeBuilder getAttributeBuilder(AttributeKey attributeKey) {
        return this.getOrCreate(attributeKey);
    }

    public AttributesBuilder appendValues(AttributeKey attributeKey, List<CleanedString> valueList) {
        if (valueList.isEmpty()) {
            return this;
        }
        AttributeBuilder builder = this.getOrCreate(attributeKey);
        for (CleanedString cs : valueList) {
            if (cs == null) continue;
            builder.addValue(cs);
        }
        return this;
    }

    public AttributesBuilder appendValues(Attribute attribute) {
        return this.appendValues(attribute.getAttributeKey(), attribute);
    }

    public AttributesBuilder appendValues(AttributeKey attributeKey, Attribute attribute) {
        AttributeBuilder builder = this.getOrCreate(attributeKey);
        int valueLength = attribute.size();
        for (int i = 0; i < valueLength; ++i) {
            builder.addValue(CleanedString.newInstance((CharSequence)attribute.get(i)));
        }
        return this;
    }

    public AttributesBuilder changeAttributes(AttributeChange attributeChange) {
        for (Attribute attribute : attributeChange.getChangedAttributes()) {
            this.put(attribute);
        }
        for (AttributeKey removedAttributeKey : attributeChange.getRemovedAttributeKeyList()) {
            this.attributeBuilderMap.remove(removedAttributeKey);
        }
        return this;
    }

    public AttributesBuilder merge(AttributesBuilder attributesBuilder) {
        for (AttributeBuilder otherAttributeBuilder : attributesBuilder.attributeBuilderMap.values()) {
            this.appendValues(otherAttributeBuilder.toAttribute());
        }
        return this;
    }

    public Attributes toAttributes() {
        if (this.attributeBuilderMap.isEmpty()) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (AttributeBuilder builder : this.attributeBuilderMap.values()) {
            Attribute attribute = builder.toAttribute();
            if (attribute == null) continue;
            attributeList.add(attribute);
        }
        int size = attributeList.size();
        if (size == 0) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        if (size == 1) {
            return AttributeUtils.toSingletonAttributes((Attribute)attributeList.get(0));
        }
        Attribute[] array = attributeList.toArray(new Attribute[size]);
        return new InternalAttributes(array);
    }

    private void put(Attribute attribute) {
        AttributeKey attributeKey = attribute.getAttributeKey();
        AttributeBuilder builder = new AttributeBuilder(attributeKey);
        for (String value : attribute) {
            builder.addValue(CleanedString.newInstance(value));
        }
        this.attributeBuilderMap.put(attributeKey, builder);
    }

    private AttributeBuilder getOrCreate(AttributeKey attributeKey) {
        AttributeBuilder builder = (AttributeBuilder)this.attributeBuilderMap.get(attributeKey);
        if (builder == null) {
            builder = new AttributeBuilder(attributeKey);
            this.attributeBuilderMap.put(attributeKey, builder);
        }
        return builder;
    }

    public static AttributesBuilder init() {
        return new AttributesBuilder();
    }

    public static AttributesBuilder init(Attributes initAttributes) {
        return new AttributesBuilder(initAttributes);
    }

    static Attributes toAttributes(Attribute[] attributeArray) {
        return new InternalAttributes(attributeArray);
    }

    private static class InternalAttributes
    extends AbstractList<Attribute>
    implements Attributes {
        private final Attribute[] attributeArray;

        private InternalAttributes(Attribute[] attributeArray) {
            this.attributeArray = attributeArray;
        }

        @Override
        public Attribute getAttribute(AttributeKey key) {
            for (Attribute attribute : this.attributeArray) {
                if (!attribute.getAttributeKey().equals(key)) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public int size() {
            return this.attributeArray.length;
        }

        @Override
        public Attribute get(int i) {
            return this.attributeArray[i];
        }
    }
}

