/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.thesaurus;

import net.fichotheque.importation.ParentChange;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.importation.TiesImport;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.TiesImportBuilder;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelChangeBuilder;
import net.mapeadores.util.text.LabelUtils;

public class EditMotcleImportBuilder {
    private final int motcleId;
    private String newIdalpha = null;
    private String newStatus = null;
    private ParentChange parentChange = null;
    protected LabelChangeBuilder labelChangeBuilder;
    protected AttributeChangeBuilder attributeChangeBuilder;
    protected TiesImportBuilder tiesImportBuilder;

    public EditMotcleImportBuilder(int motcleId) {
        this.motcleId = motcleId;
    }

    public EditMotcleImportBuilder setNewIdalpha(String newIdalpha) {
        this.newIdalpha = newIdalpha;
        return this;
    }

    public EditMotcleImportBuilder setNewStatus(String newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    public EditMotcleImportBuilder setParent(ParentChange parentChange) {
        this.parentChange = parentChange;
        return this;
    }

    public LabelChangeBuilder getLabelChangeBuilder() {
        if (this.labelChangeBuilder == null) {
            this.labelChangeBuilder = new LabelChangeBuilder();
        }
        return this.labelChangeBuilder;
    }

    public AttributeChangeBuilder getAttributeChangeBuilder() {
        if (this.attributeChangeBuilder == null) {
            this.attributeChangeBuilder = new AttributeChangeBuilder();
        }
        return this.attributeChangeBuilder;
    }

    public TiesImportBuilder getTiesImportBuilder() {
        if (this.tiesImportBuilder == null) {
            this.tiesImportBuilder = new TiesImportBuilder();
        }
        return this.tiesImportBuilder;
    }

    private LabelChange getLabelChange() {
        if (this.labelChangeBuilder == null) {
            return LabelUtils.EMPTY_LABELCHANGE;
        }
        return this.labelChangeBuilder.toLabelChange();
    }

    private AttributeChange getAttributeChange() {
        if (this.attributeChangeBuilder == null) {
            return AttributeUtils.EMPTY_ATTRIBUTECHANGE;
        }
        return this.attributeChangeBuilder.toAttributeChange();
    }

    private TiesImport getTiesImport() {
        if (this.tiesImportBuilder == null) {
            return ImportationUtils.EMPTY_TIESIMPORT;
        }
        return this.tiesImportBuilder.toTiesImport();
    }

    public ThesaurusImport.EditMotcleImport toEditMotcleImport() {
        return new InternalEditMotcleImport(this.motcleId, this.newIdalpha, this.newStatus, this.parentChange, this.getLabelChange(), this.getAttributeChange(), this.getTiesImport());
    }

    public static EditMotcleImportBuilder init(int motcleId) {
        return new EditMotcleImportBuilder(motcleId);
    }

    private static class InternalEditMotcleImport
    implements ThesaurusImport.EditMotcleImport {
        private final int motcleId;
        private final String newIdalpha;
        private final String newStatus;
        private final ParentChange parentChange;
        private final LabelChange labelChange;
        private final AttributeChange attributeChange;
        private final TiesImport tiesImport;

        private InternalEditMotcleImport(int motcleId, String newIdalpha, String newStatus, ParentChange parentChange, LabelChange labelChange, AttributeChange attributeChange, TiesImport tiesImport) {
            this.motcleId = motcleId;
            this.newIdalpha = newIdalpha;
            this.newStatus = newStatus;
            this.parentChange = parentChange;
            this.labelChange = labelChange;
            this.attributeChange = attributeChange;
            this.tiesImport = tiesImport;
        }

        @Override
        public int getMotcleId() {
            return this.motcleId;
        }

        @Override
        public String getNewIdalpha() {
            return this.newIdalpha;
        }

        @Override
        public ParentChange getParentChange() {
            return this.parentChange;
        }

        @Override
        public String getNewStatus() {
            return this.newStatus;
        }

        @Override
        public LabelChange getLabelChange() {
            return this.labelChange;
        }

        @Override
        public AttributeChange getAttributeChange() {
            return this.attributeChange;
        }

        @Override
        public TiesImport getTiesImport() {
            return this.tiesImport;
        }
    }
}

