/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.album.Illustration;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.IllustrationFormatter;
import net.fichotheque.tools.format.JsonParameters;
import net.fichotheque.tools.format.catalogs.IllustrationFormatterCatalog;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class IllustrationFormatterParser {
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.build("type", "id", "format");

    private IllustrationFormatterParser() {
    }

    public static IllustrationFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = "{album}-{id}.{format}";
        }
        try {
            return IllustrationFormatterParser.parse(pattern, formatContext, withWeightFilter);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static IllustrationFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, withWeightFilter), pattern);
        return new InternalIllustrationFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withWeightFilter;

        private InternalInstructionResolver(FormatContext formatContext, boolean withWeightFilter) {
            this.provider = formatContext.getInstructionResolverProvider();
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(IllustrationFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "album": {
                    return IllustrationFormatterCatalog.ALBUM;
                }
                case "format": {
                    return IllustrationFormatterCatalog.FORMAT;
                }
                case "formsyntax": {
                    if (this.withWeightFilter) {
                        return IllustrationFormatterCatalog.WITHWEIGHTFILTER_FORMSYNTAX;
                    }
                    return IllustrationFormatterCatalog.WITHOUTWEIGHTFILTER_FORMSYNTAX;
                }
                case "id": 
                case "idalbum": {
                    return IllustrationFormatterCatalog.ID;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction, DEFAULT_JSONPARAMETERS);
                    return new IllustrationFormatterCatalog.Json(jsonParameters);
                }
                case "weight": 
                case "poids": {
                    return IllustrationFormatterCatalog.WEIGHT;
                }
            }
            return null;
        }
    }

    private static class InternalIllustrationFormatter
    implements IllustrationFormatter {
        private final Object[] partArray;

        private InternalIllustrationFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatIllustration(Illustration illustration, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                IllustrationFormatter formatter = (IllustrationFormatter)obj;
                buf.append(formatter.formatIllustration(illustration, weight, formatSource));
            }
            return buf.toString();
        }
    }
}

