/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.thesaurus.metadata;

import net.fichotheque.Metadata;
import net.fichotheque.namespaces.BdfSpace;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.Phrase;

public interface ThesaurusMetadata
extends Metadata {
    public static final String MULTI_TYPE = "multi";
    public static final String IDALPHA_TYPE = "idalpha";
    public static final String BABELIEN_TYPE = "babelien";

    public Thesaurus getThesaurus();

    public String getThesaurusType();

    public Langs getAuthorizedLangs();

    default public boolean isWithFicheStyle() {
        Phrase phrase = this.getPhrases().getPhrase("fichestyle");
        return phrase != null;
    }

    default public boolean isBracketsIdalphaStyle() {
        Attribute attribute = this.getAttributes().getAttribute(BdfSpace.IDALPHASTYLE_KEY);
        if (attribute == null) {
            return false;
        }
        return attribute.contains("brackets");
    }

    default public boolean isLongIdalphaStyle() {
        Attribute attribute = this.getAttributes().getAttribute(BdfSpace.IDALPHASTYLE_KEY);
        if (attribute == null) {
            return false;
        }
        return attribute.contains("long");
    }

    public static String checkThesaurusType(String thesaurusType) {
        switch (thesaurusType) {
            case "babelien": 
            case "babelian": {
                return BABELIEN_TYPE;
            }
            case "idalpha": {
                return IDALPHA_TYPE;
            }
            case "multi": {
                return MULTI_TYPE;
            }
        }
        throw new IllegalArgumentException("wrong type");
    }
}

