/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;

class FicheItemsImpl
extends AbstractList<FicheItem>
implements FicheItems,
Serializable {
    private static final long serialVersionUID = 4L;
    private int size = 0;
    private FicheItem[] items = new FicheItem[4];

    FicheItemsImpl() {
    }

    @Override
    public FicheItem get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.items[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, null);
        this.size = 0;
    }

    @Override
    public boolean add(FicheItem ficheItem) {
        if (ficheItem == null) {
            throw new NullPointerException();
        }
        return this.innerAdd(ficheItem);
    }

    void addFicheItems(FicheItems ficheItems) {
        int othersize = ficheItems.size();
        for (int i = 0; i < othersize; ++i) {
            this.innerAdd((FicheItem)ficheItems.get(i));
        }
    }

    private boolean innerAdd(FicheItem item) {
        for (int i = 0; i < this.size; ++i) {
            if (!item.equals(this.items[i])) continue;
            return false;
        }
        this.checkLength();
        this.items[this.size] = item;
        ++this.size;
        return true;
    }

    private void checkLength() {
        if (this.size == this.items.length) {
            FicheItem[] nv = new FicheItem[this.size * 2];
            System.arraycopy(this.items, 0, nv, 0, this.size);
            this.items = nv;
        }
    }
}

