/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.RandomAccess;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.AttsImpl;
import net.fichotheque.corpus.fiche.Ln;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.corpus.fiche.ZoneBlock;

public class Code
extends AbstractList<Ln>
implements ZoneBlock,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 5L;
    public static final short TYPE_NONE = 0;
    public static final short TYPE_XML = 1;
    public static final short TYPE_SCRIPT = 2;
    private final ParagraphBlock numero = new ParagraphBlock();
    private final ParagraphBlock legende = new ParagraphBlock();
    private short type = 0;
    private Ln[] lnArray = new Ln[8];
    private int size = 0;
    private AttsImpl attsImpl;

    public Code(short type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("wrong type value");
        }
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Ln get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.lnArray[index];
    }

    @Override
    public boolean add(Ln ln) {
        if (ln == null) {
            throw new NullPointerException();
        }
        this.checkLength();
        this.lnArray[this.size] = ln;
        ++this.size;
        return true;
    }

    @Override
    public TextContent getNumero() {
        return this.numero;
    }

    @Override
    public TextContent getLegende() {
        return this.legende;
    }

    @Override
    public TextContentBuilder getNumeroBuilder() {
        return this.numero;
    }

    @Override
    public TextContentBuilder getLegendeBuilder() {
        return this.legende;
    }

    @Override
    public Atts getAtts() {
        return AttsImpl.check(this.attsImpl);
    }

    @Override
    public void putAtt(String name, String value) {
        this.attsImpl = AttsImpl.put(this.attsImpl, name, value);
    }

    private void checkLength() {
        if (this.size == this.lnArray.length) {
            Ln[] nv = new Ln[this.size * 2];
            System.arraycopy(this.lnArray, 0, nv, 0, this.size);
            this.lnArray = nv;
        }
    }

    public static short typeToShort(String strg_type) {
        if (strg_type == null || strg_type.length() == 0) {
            return 0;
        }
        if (strg_type.equals("xml")) {
            return 1;
        }
        if (strg_type.equals("script")) {
            return 2;
        }
        return 0;
    }

    public static String typeToString(short type) {
        switch (type) {
            case 1: {
                return "xml";
            }
            case 2: {
                return "script";
            }
        }
        return "";
    }

    public static char typeToInitiale(short type) {
        switch (type) {
            case 1: {
                return 'x';
            }
            case 2: {
                return 's';
            }
        }
        return '0';
    }

    public static short typeToShort(char initiale) {
        switch (initiale) {
            case 'x': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        return 0;
    }
}

