/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.docstream;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.libscol.LibsColKey;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.xml.dyn.Icon32SvgWriter;
import fr.exemole.bdfserver.xml.dyn.LabelsXMLPart;
import fr.exemole.bdfserver.xml.dyn.LibsColXMLPart;
import fr.exemole.bdfserver.xml.dyn.LibsXMLPart;
import fr.exemole.bdfserver.xml.dyn.LogoResourceXMLPart;
import fr.exemole.bdfserver.xml.dyn.UserXMLPart;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.docstream.StringDocStream;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public final class DynamicDocStreamFactory {
    private static final String[] EMPTY_SUBDIRS = new String[0];

    private DynamicDocStreamFactory() {
    }

    public static DocStream getPublicDocStream(BdfServer bdfServer, String path) {
        DynPath dynPath = DynamicDocStreamFactory.toDynPath(path);
        if (dynPath == null) {
            return null;
        }
        switch (dynPath.getMainDir()) {
            case "images": {
                return DynamicDocStreamFactory.getSvgDocStream(bdfServer, dynPath);
            }
        }
        return null;
    }

    public static DocStream getAdminDocStream(BdfServer bdfServer, String path) {
        DynPath dynPath = DynamicDocStreamFactory.toDynPath(path);
        if (dynPath == null) {
            return null;
        }
        switch (dynPath.getMainDir()) {
            case "libs": {
                return DynamicDocStreamFactory.getLibsDocStream(bdfServer, dynPath);
            }
            case "libscol": {
                return DynamicDocStreamFactory.getLibscolDocStream(bdfServer, dynPath);
            }
            case "labels": {
                return DynamicDocStreamFactory.getLabelsDocStream(bdfServer, dynPath);
            }
            case "labelslist": {
                return DynamicDocStreamFactory.getLabelsListDocStream(bdfServer, dynPath);
            }
            case "users": {
                return DynamicDocStreamFactory.getUsersDocStream(bdfServer, dynPath);
            }
            case "logos": {
                return DynamicDocStreamFactory.getLogosDocStream(bdfServer, dynPath);
            }
        }
        return null;
    }

    private static DocStream getSvgDocStream(BdfServer bdfServer, DynPath dynPath) {
        if (!dynPath.getExtension().equals("svg")) {
            return null;
        }
        if (dynPath.hasSubDirs()) {
            return null;
        }
        String svgText = null;
        switch (dynPath.getBasename()) {
            case "icon32": {
                svgText = Icon32SvgWriter.getSvgString(bdfServer);
            }
        }
        if (svgText == null) {
            return null;
        }
        return DynamicDocStreamFactory.toDocStream(svgText, "image/svg+xml");
    }

    private static DocStream getLibsDocStream(BdfServer bdfServer, DynPath dynPath) {
        String text;
        Lang lang;
        if (!dynPath.getExtension().equals("xml")) {
            return null;
        }
        if (dynPath.hasSubDirs()) {
            return null;
        }
        String basename = dynPath.getBasename();
        int idx = basename.indexOf(95);
        if (idx == -1) {
            return null;
        }
        int idx2 = basename.indexOf(95, idx + 1);
        if (idx2 == -1) {
            return null;
        }
        try {
            lang = Lang.parse(basename.substring(idx2 + 1));
        }
        catch (ParseException pe) {
            return null;
        }
        String subname = basename.substring(0, idx2);
        if (subname.startsWith("special_")) {
            text = LibsXMLPart.getLibsXML(lang, bdfServer.getFichotheque(), basename.substring(8), true);
        } else {
            try {
                SubsetKey subsetKey = SubsetKey.parse(subname);
                text = LibsXMLPart.getLibsXML(lang, bdfServer.getFichotheque(), subsetKey, true);
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return DynamicDocStreamFactory.toDocStream(text, "text/xml");
    }

    private static DocStream getLibscolDocStream(BdfServer bdfServer, DynPath dynPath) {
        if (!dynPath.getExtension().equals("xml")) {
            return null;
        }
        if (dynPath.hasSubDirs()) {
            return null;
        }
        String basename = dynPath.getBasename();
        int idxlang = basename.lastIndexOf(95);
        if (idxlang == -1) {
            return null;
        }
        try {
            Lang lang = Lang.parse(basename.substring(idxlang + 1));
            LibsColKey key = LibsColKey.parse(basename.substring(0, idxlang));
            String text = LibsColXMLPart.getLibsColXML(lang, bdfServer, key, true);
            return DynamicDocStreamFactory.toDocStream(text, "text/xml");
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static DocStream getLabelsDocStream(BdfServer bdfServer, DynPath dynPath) {
        Subset subset;
        Lang lang;
        if (!dynPath.getExtension().equals("xml")) {
            return null;
        }
        if (dynPath.hasSubDirs()) {
            return null;
        }
        String basename = dynPath.getBasename();
        int langIdx = basename.lastIndexOf(95);
        if (langIdx == -1) {
            return null;
        }
        try {
            lang = Lang.parse(basename.substring(langIdx + 1));
        }
        catch (ParseException pe) {
            return null;
        }
        Fichotheque fichotheque = bdfServer.getFichotheque();
        try {
            SubsetKey subsetKey = SubsetKey.parse(basename.substring(0, langIdx));
            subset = fichotheque.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
        if (subset == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(1024);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, 0);
        try {
            xmlWriter.appendXMLDeclaration();
            LabelsXMLPart labelsXMLPart = new LabelsXMLPart(xmlWriter, bdfServer, lang);
            labelsXMLPart.appendLabels(subset);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DynamicDocStreamFactory.toDocStream(buf.toString(), "text/xml");
    }

    private static DocStream getLabelsListDocStream(BdfServer bdfServer, DynPath dynPath) {
        String typeString;
        Lang lang;
        if (!dynPath.getExtension().equals("xml")) {
            return null;
        }
        if (dynPath.hasSubDirs()) {
            return null;
        }
        String basename = dynPath.getBasename();
        int langIdx = basename.lastIndexOf(95);
        if (langIdx == -1) {
            return null;
        }
        try {
            lang = Lang.parse(basename.substring(langIdx + 1));
        }
        catch (ParseException pe) {
            return null;
        }
        Fichotheque fichotheque = bdfServer.getFichotheque();
        switch (typeString = basename.substring(0, langIdx)) {
            case "corpus": {
                break;
            }
            default: {
                return null;
            }
        }
        StringBuilder buf = new StringBuilder(1024);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, 0);
        try {
            xmlWriter.appendXMLDeclaration();
            LabelsXMLPart labelsColXMLPart = new LabelsXMLPart(xmlWriter, bdfServer, lang);
            xmlWriter.openTag("labels-list");
            for (Corpus corpus : fichotheque.getCorpusList()) {
                labelsColXMLPart.appendLabels(corpus);
            }
            xmlWriter.closeTag("labels-list");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DynamicDocStreamFactory.toDocStream(buf.toString(), "text/xml");
    }

    private static DocStream getUsersDocStream(BdfServer bdfServer, DynPath dynPath) {
        Corpus specificCorpus;
        if (!dynPath.getExtension().equals("xml")) {
            return null;
        }
        if (dynPath.getSubDirsLength() != 2) {
            return null;
        }
        if (!dynPath.getSubDir(1).equals("ui")) {
            return null;
        }
        String baseName = dynPath.getBasename();
        boolean isAll = false;
        if (baseName.equals("_all")) {
            isAll = true;
            specificCorpus = null;
        } else {
            try {
                SubsetKey subsetKey = SubsetKey.parse(baseName);
                Subset subset = bdfServer.getFichotheque().getSubset(subsetKey);
                if (subset == null || !subsetKey.isCorpusSubset()) {
                    return null;
                }
                specificCorpus = (Corpus)subset;
            }
            catch (ParseException pe) {
                return null;
            }
        }
        StringBuilder buf = new StringBuilder(1024);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, 0);
        if (dynPath.getSubDir(0).equals("_default")) {
            try {
                xmlWriter.appendXMLDeclaration();
                UserXMLPart.writeDefaultUser(xmlWriter);
            }
            catch (IOException iOException) {}
        } else {
            Redacteur redacteur;
            try {
                redacteur = bdfServer.getFichothequeQuestioner().getRedacteurByLogin(dynPath.getSubDir(0));
            }
            catch (UserLoginException e) {
                return null;
            }
            BdfUser bdfUser = bdfServer.createBdfUser(redacteur);
            DefaultBdfParameters bdfParameters = new DefaultBdfParameters(bdfServer, bdfUser);
            PermissionSummary permissionSummary = bdfParameters.getPermissionSummary();
            try {
                xmlWriter.appendXMLDeclaration();
                UserXMLPart userXMLPart = new UserXMLPart(xmlWriter, bdfServer, bdfUser, permissionSummary);
                userXMLPart.start();
                if (isAll) {
                    for (Corpus corpus : bdfServer.getFichotheque().getCorpusList()) {
                        userXMLPart.addCorpusUi(corpus);
                    }
                } else {
                    userXMLPart.addCorpusUi(specificCorpus);
                }
                userXMLPart.end();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DynamicDocStreamFactory.toDocStream(buf.toString(), "text/xml");
    }

    private static DocStream getLogosDocStream(BdfServer bdfServer, DynPath dynPath) {
        String basename;
        if (!dynPath.getExtension().equals("xml")) {
            return null;
        }
        if (dynPath.hasSubDirs()) {
            return null;
        }
        switch (basename = dynPath.getBasename()) {
            case "odt": {
                break;
            }
            default: {
                return null;
            }
        }
        StringBuilder buf = new StringBuilder(1024);
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf, 0);
        try {
            xmlWriter.appendXMLDeclaration();
            LogoResourceXMLPart logoXMLPart = new LogoResourceXMLPart(xmlWriter, bdfServer);
            logoXMLPart.appendForDestination(basename);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DynamicDocStreamFactory.toDocStream(buf.toString(), "text/xml");
    }

    private static DocStream toDocStream(String s, String mimeType) {
        if (s == null) {
            return null;
        }
        return new StringDocStream(s, mimeType);
    }

    private static DynPath toDynPath(String filePath) {
        String[] subDirs;
        String[] parseResult = DynamicDocStreamFactory.parse(filePath);
        if (parseResult == null) {
            return null;
        }
        int length = parseResult.length;
        if (length < 2) {
            return null;
        }
        String mainDir = parseResult[0];
        String fileName = parseResult[length - 1];
        int idx = fileName.lastIndexOf(46);
        if (idx < 1 || idx == fileName.length() - 1) {
            return null;
        }
        String basename = fileName.substring(0, idx);
        String extension = fileName.substring(idx + 1);
        if (length > 2) {
            subDirs = new String[length - 2];
            System.arraycopy(parseResult, 1, subDirs, 0, length - 2);
        } else {
            subDirs = EMPTY_SUBDIRS;
        }
        return new DynPath(mainDir, subDirs, basename, extension);
    }

    private static String[] parse(String filePath) {
        int idx = filePath.indexOf(47);
        if (idx == -1) {
            int idx2 = filePath.indexOf(95);
            if (idx2 > 0 && idx2 < filePath.length() - 1) {
                String[] result = new String[]{filePath.substring(0, idx2), filePath.substring(idx2 + 1)};
                return result;
            }
            return null;
        }
        try {
            RelativePath relativePath = RelativePath.parse(filePath);
            String[] result = relativePath.toArray();
            if (result.length < 2) {
                return null;
            }
            return result;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static class DynPath {
        private final String mainDir;
        private final String[] subDirs;
        private final String basename;
        private final String extension;

        private DynPath(String mainDir, String[] subDirs, String basename, String extension) {
            this.mainDir = mainDir;
            this.subDirs = subDirs;
            this.basename = basename;
            this.extension = extension;
        }

        private String getMainDir() {
            return this.mainDir;
        }

        private int getSubDirsLength() {
            return this.subDirs.length;
        }

        private String getSubDir(int index) {
            return this.subDirs[index];
        }

        private String getExtension() {
            return this.extension;
        }

        private boolean hasSubDirs() {
            return this.subDirs.length > 0;
        }

        private String getBasename() {
            return this.basename;
        }
    }
}

