/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.tools;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataStorageFileCatalog;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import fr.exemole.bdfserver.xml.roles.RedacteurListXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.xml.storage.RedacteurStorageXMLPart;
import net.fichotheque.xml.storage.SphereListXMLPart;
import net.fichotheque.xml.storage.SphereMetadataXMLPart;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public final class SphereCopyEngine {
    private final StorageDirectory bdfdataDirectory;
    private final BdfServer sourceBdfServer;

    private SphereCopyEngine(StorageDirectory bdfdataDirectory, BdfServer sourceBdfServer) {
        this.bdfdataDirectory = bdfdataDirectory;
        this.sourceBdfServer = sourceBdfServer;
    }

    private void run() {
        for (Sphere sphere : this.sourceBdfServer.getFichotheque().getSphereList()) {
            this.copySphereMetadata(sphere);
            this.copySphereList(sphere);
            this.copyRedacteurList(sphere);
        }
        this.copyAdmin();
        this.copyPasswords();
    }

    private void copySphereList(Sphere sphere) {
        StorageFile listStorageFile = BdfdataStorageFileCatalog.sphereList(this.bdfdataDirectory, sphere.getSubsetKey());
        try (BufferedWriter buf = listStorageFile.getWriter(false);){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            SphereListXMLPart sphereMetadataXMLPart = new SphereListXMLPart(xmlWriter);
            sphereMetadataXMLPart.appendSphereList(sphere, null);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private void copySphereMetadata(Sphere sphere) {
        StorageFile storageFile = BdfdataStorageFileCatalog.sphereMetadata(this.bdfdataDirectory, sphere.getSubsetKey());
        try (BufferedWriter buf = storageFile.getWriter(false);){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            SphereMetadataXMLPart sphereMetadataXMLPart = new SphereMetadataXMLPart(xmlWriter);
            sphereMetadataXMLPart.appendSphereMetadata(sphere.getSphereMetadata());
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private void copyRedacteurList(Sphere sphere) {
        SubsetKey sphereKey = sphere.getSubsetKey();
        for (Redacteur redacteur : sphere.getRedacteurList()) {
            StorageFile storageFile = BdfdataStorageFileCatalog.redacteur(this.bdfdataDirectory, sphereKey, redacteur.getId());
            try {
                BufferedWriter buf = storageFile.getWriter(false);
                try {
                    AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
                    xmlWriter.appendXMLDeclaration();
                    RedacteurStorageXMLPart redacteurStorageXMLPart = new RedacteurStorageXMLPart(xmlWriter);
                    redacteurStorageXMLPart.appendRedacteur(redacteur);
                }
                finally {
                    if (buf == null) continue;
                    buf.close();
                }
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }

    private void copyAdmin() {
        StorageFile adminFile = this.bdfdataDirectory.getStorageFile("conf" + File.separator + "redacteurlists" + File.separator + "admin.xml");
        try (BufferedWriter buf = adminFile.getWriter(false);){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            RedacteurListXMLPart xmlPart = new RedacteurListXMLPart(xmlWriter);
            xmlPart.addRedacteurList(this.sourceBdfServer.getPermissionManager().getAdminRedacteurList());
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    private void copyPasswords() {
        String[] passwordArray = this.sourceBdfServer.getPasswordManager().toPasswordArray();
        StorageFile passwordStorageFile = BdfdataStorageFileCatalog.password(this.bdfdataDirectory);
        try (BufferedWriter writer = passwordStorageFile.getWriter(false);){
            StorageUtils.writePasswordArray(writer, passwordArray);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public static void run(StorageDirectory bdfdataDirectory, BdfServer sourceBdfServer) {
        SphereCopyEngine engine = new SphereCopyEngine(bdfdataDirectory, sourceBdfServer);
        engine.run();
    }

    public static void run(BdfServerDirs dirs, BdfServer sourceBdfServer) {
        SphereCopyEngine.run(BdfdataDirectory.build(dirs), sourceBdfServer);
    }
}

