/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.io.IOUtils;

public final class StorageDirectoryUtils {
    private StorageDirectoryUtils() {
    }

    public static StorageDirectory toStorageDirectory(ConfDirs confDirs, boolean createIfMissing) {
        return StorageDirectoryUtils.toStorageDirectory(confDirs.getDir("var.data"), confDirs.getDir("var.backup"), createIfMissing);
    }

    public static StorageDirectory toStorageDirectory(ConfDirs confDirs, String subPath) {
        return StorageDirectoryUtils.toStorageDirectory(confDirs, subPath, false);
    }

    public static StorageDirectory toStorageDirectory(ConfDirs confDirs, String subPath, boolean createIfMissing) {
        File bdfdataDir = confDirs.getSubPath("var.data", subPath);
        File backupDir = confDirs.getSubPath("var.backup", subPath);
        return StorageDirectoryUtils.toStorageDirectory(bdfdataDir, backupDir, createIfMissing);
    }

    public static StorageDirectory toStorageDirectory(File dataDir, @Nullable File backupDir, boolean createIfMissing) {
        if (createIfMissing) {
            StorageDirectoryUtils.testDirectory(dataDir);
            if (backupDir != null) {
                StorageDirectoryUtils.testDirectory(backupDir);
            }
        }
        return new InternalStorageDirectory(dataDir, backupDir);
    }

    public static void testDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        } else if (!directory.isDirectory()) {
            throw new BdfStorageException(directory.getPath() + " is not a directory");
        }
    }

    public static void archiveAndDeleteDirectory(StorageFile dir, EditOrigin editOrigin) {
        if (!dir.isDirectory()) {
            return;
        }
        for (StorageFile subFile : dir.listFiles()) {
            if (subFile.isDirectory()) {
                StorageDirectoryUtils.archiveAndDeleteDirectory(subFile, editOrigin);
                continue;
            }
            subFile.archiveAndDelete(editOrigin);
        }
        dir.delete();
    }

    public static void copyAndArchiveDirectory(File sourceDirectory, StorageFile destinationDir, EditOrigin editOrigin) {
        for (File f : sourceDirectory.listFiles()) {
            StorageFile destinationSubfile = destinationDir.getSubStorageFile(f.getName());
            if (f.isDirectory()) {
                StorageDirectoryUtils.copyAndArchiveDirectory(f, destinationSubfile, editOrigin);
                continue;
            }
            try (FileInputStream is = new FileInputStream(f);
                 BufferedOutputStream os = destinationSubfile.archiveAndGetOutputStream(editOrigin);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }

    private static class InternalStorageDirectory
    implements StorageDirectory {
        private final File dataDir;
        private final File backupDir;

        private InternalStorageDirectory(File dataDir, File backupDir) {
            this.dataDir = dataDir;
            this.backupDir = backupDir;
        }

        @Override
        public File getDataDir() {
            return this.dataDir;
        }

        @Override
        public File getBackupDir() {
            return this.backupDir;
        }
    }
}

