/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.subscribe;

import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.multi.subscribe.SubscribeManager;
import fr.exemole.bdfserver.multi.subscribe.SubscribeParameters;
import fr.exemole.bdfserver.multi.subscribe.SubscribeResult;
import fr.exemole.bdfserver.multi.subscribe.SubscribeToken;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;

public abstract class SubscribeCommand
extends AbstractMultiCommand {
    public static final String TOKEN_PARAMNAME = "token";
    protected final SubscribeManager subscribeManager;
    protected final SubscribeParameters subscribeParameters;

    public SubscribeCommand(SubscribeParameters subscribeParameters) {
        super(subscribeParameters.multi(), subscribeParameters.requestMap());
        this.subscribeManager = subscribeParameters.subscribeManager();
        this.subscribeParameters = subscribeParameters;
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        SubscribeResult result = this.doSubscribeCommand();
        return result.commandMessage();
    }

    public abstract void testCommand() throws ErrorMessageException;

    public abstract SubscribeResult doSubscribeCommand() throws ErrorMessageException;

    public static SubscribeToken getValidToken(SubscribeParameters subscribeParameters, String token) throws ErrorMessageException {
        SubscribeToken subscribeToken = subscribeParameters.subscribeManager().getSubcribeToken(token);
        if (subscribeToken == null) {
            throw new ErrorMessageException("_ error.unknown.subscribe.token", token);
        }
        if (subscribeToken.isExpired()) {
            throw new ErrorMessageException("_ error.unsupported.subscribe.token", token);
        }
        if (subscribeToken.isUsed()) {
            throw new ErrorMessageException("_ error.existing.subscribe.token", token);
        }
        return subscribeToken;
    }
}

