/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.jsonproducers.misc;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.memento.MementoNode;
import fr.exemole.bdfserver.api.memento.MementoUnit;
import fr.exemole.bdfserver.json.MementoNodeJson;
import fr.exemole.bdfserver.tools.memento.MementoEngine;
import java.io.IOException;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.text.RelativePath;

public class MementoUnitJsonProducer
implements JsonProducer {
    private final MementoUnit mementoUnit;

    public MementoUnitJsonProducer(BdfParameters bdfParameters, RelativePath path) {
        this.mementoUnit = MementoEngine.getMementoUnit(bdfParameters, path);
    }

    @Override
    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jw = new JSONWriter(appendable);
        jw.object();
        jw.key("mementoUnit");
        jw.object();
        jw.key("name").value(this.mementoUnit.getName());
        jw.key("path").value(this.mementoUnit.getPath().toString());
        jw.key("title").value(this.mementoUnit.getTitle());
        jw.key("subnodeArray");
        jw.array();
        for (MementoNode mementoNode : this.mementoUnit.getSubnodeList()) {
            MementoNodeJson.object(jw, mementoNode);
        }
        jw.endArray();
        jw.endObject();
        jw.endObject();
    }
}

