/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.api.storage.TableExportStorage;
import fr.exemole.bdfserver.tools.exportation.table.TableExportCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.TableDef;
import net.fichotheque.exportation.table.TableExport;
import net.fichotheque.exportation.table.TableExportContentDescription;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.exportation.table.TableExportDescription;
import net.fichotheque.tools.exportation.table.SubsetTableBuilder;
import net.fichotheque.tools.exportation.table.TableExportBuilder;
import net.fichotheque.utils.TableDefUtils;
import net.fichotheque.utils.TableExportUtils;
import net.mapeadores.util.io.IOUtils;

class TableExportManagerImpl
implements TableExportManager {
    private final Fichotheque fichotheque;
    private final TableExportStorage tableExportStorage;
    private final TableExportContext tableExportContext;
    private final SortedMap<String, TableExportDescription> tableExportDescriptionMap = new TreeMap<String, TableExportDescription>();
    private final SortedMap<String, TableExportDescription> validTableExportDescriptionMap = new TreeMap<String, TableExportDescription>();
    private List<TableExportDescription> tableExportDescriptionList = Collections.emptyList();
    private List<TableExportDescription> validTableExportDescriptionList = Collections.emptyList();

    TableExportManagerImpl(Fichotheque fichotheque, TableExportStorage tableExportStorage, TableExportContext tableExportContext) {
        this.fichotheque = fichotheque;
        this.tableExportStorage = tableExportStorage;
        this.tableExportContext = tableExportContext;
    }

    @Override
    public synchronized void update() {
        this.tableExportDescriptionMap.clear();
        this.validTableExportDescriptionMap.clear();
        TableExportStorage.Unit[] array = this.tableExportStorage.checkStorage();
        TableExportCompiler compiler = new TableExportCompiler(this.tableExportContext);
        for (TableExportStorage.Unit storageUnit : array) {
            TableExportDescription tableExportDescription = compiler.compile(storageUnit);
            if (tableExportDescription.isValid()) {
                this.validTableExportDescriptionMap.put(tableExportDescription.getName(), tableExportDescription);
            }
            this.tableExportDescriptionMap.put(tableExportDescription.getName(), tableExportDescription);
        }
        this.initLists();
    }

    @Override
    public synchronized List<TableExportDescription> getTableExportDescriptionList() {
        return this.tableExportDescriptionList;
    }

    @Override
    public synchronized List<TableExportDescription> getValidTableExportDescriptionList() {
        return this.validTableExportDescriptionList;
    }

    @Override
    public synchronized String getTableExportContent(String tableExportName, String contentPath) {
        StorageContent storageContent = this.tableExportStorage.getStorageContent(tableExportName, contentPath);
        if (storageContent != null) {
            String string;
            block9: {
                InputStream is = storageContent.getInputStream();
                try {
                    string = IOUtils.toString(is, "UTF-8");
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new BdfStorageException(ioe);
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    @Override
    public synchronized TableExportDescription putTableExportDef(TableExportDef tableExportDef, EditOrigin editOrigin) {
        String tableExportName = tableExportDef.getName();
        this.tableExportStorage.saveTableExportDef(tableExportDef, editOrigin);
        return this.reinitTableExportDescription(tableExportName);
    }

    @Override
    public synchronized TableExportDescription putTableExportContent(String tableExportName, String contentPath, InputStream inputStream, EditOrigin editOrigin) throws IOException {
        if (this.tableExportDescriptionMap.containsKey(tableExportName)) {
            this.tableExportStorage.saveStorageContent(tableExportName, contentPath, inputStream, editOrigin);
            return this.reinitTableExportDescription(tableExportName);
        }
        return null;
    }

    @Override
    public synchronized TableExportDescription removeTableExportContent(String tableExportName, String contentPath, EditOrigin editOrigin) {
        boolean done = this.tableExportStorage.removeStorageContent(tableExportName, contentPath, editOrigin);
        if (done) {
            return this.reinitTableExportDescription(tableExportName);
        }
        return null;
    }

    @Override
    public synchronized TableExportDescription putTableDef(String tableExportName, SubsetKey corpusKey, TableDef tableDef, EditOrigin editOrigin) {
        StringBuilder buf = new StringBuilder();
        try {
            TableDefUtils.writeTableDef(buf, tableDef);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (InputStream is = IOUtils.toInputStream(buf.toString(), "UTF-8");){
            this.tableExportStorage.saveStorageContent(tableExportName, corpusKey + ".txt", is, editOrigin);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        return this.reinitTableExportDescription(tableExportName);
    }

    @Override
    public synchronized TableExport getTableExport(String tableExportName) {
        TableExportDescription tableExportDescription = (TableExportDescription)this.validTableExportDescriptionMap.get(tableExportName);
        if (tableExportDescription == null) {
            return null;
        }
        TableExportBuilder tableExportBuilder = TableExportBuilder.init().setTableExportDef(tableExportDescription.getTableExportDef());
        for (TableExportContentDescription contentDescription : tableExportDescription.getTableExportContentDescriptionList()) {
            Subset subset;
            SubsetKey subsetKey;
            if (!contentDescription.isValid() || (subsetKey = contentDescription.getSubsetKey()) == null || (subset = this.fichotheque.getSubset(subsetKey)) == null) continue;
            tableExportBuilder.addSubsetTable(SubsetTableBuilder.init(subset).populate(contentDescription.getTableDef(), this.tableExportContext).toSubsetTable());
        }
        return tableExportBuilder.toTableExport();
    }

    @Override
    public synchronized boolean containsTableExport(String tableExportName) {
        return this.validTableExportDescriptionMap.containsKey(tableExportName);
    }

    @Override
    public synchronized void removeTableExport(String tableExportName, EditOrigin editOrigin) {
        boolean done = this.tableExportStorage.removeTableExport(tableExportName, editOrigin);
        if (done) {
            this.update();
        }
    }

    @Override
    public synchronized TableExportDescription copyTableExport(String tableExportName, String newTableExportName, EditOrigin editOrigin) {
        boolean done = this.tableExportStorage.copyTableExport(tableExportName, newTableExportName, editOrigin);
        if (done) {
            this.update();
            return (TableExportDescription)this.tableExportDescriptionMap.get(newTableExportName);
        }
        return null;
    }

    private TableExportDescription reinitTableExportDescription(String tableExportName) {
        TableExportCompiler compiler = new TableExportCompiler(this.tableExportContext);
        TableExportStorage.Unit tableExportStorageUnit = this.tableExportStorage.getTableExportStorageUnit(tableExportName);
        TableExportDescription tableExportDescription = compiler.compile(tableExportStorageUnit);
        if (tableExportDescription.isValid()) {
            this.validTableExportDescriptionMap.put(tableExportName, tableExportDescription);
        } else {
            this.validTableExportDescriptionMap.remove(tableExportName);
        }
        this.tableExportDescriptionMap.put(tableExportName, tableExportDescription);
        this.initLists();
        return tableExportDescription;
    }

    private void initLists() {
        this.tableExportDescriptionList = TableExportUtils.wrap(this.tableExportDescriptionMap.values().toArray(new TableExportDescription[this.tableExportDescriptionMap.size()]));
        this.validTableExportDescriptionList = TableExportUtils.wrap(this.validTableExportDescriptionMap.values().toArray(new TableExportDescription[this.validTableExportDescriptionMap.size()]));
    }
}

