/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.configuration;

import fr.exemole.bdfserver.api.groups.GroupDef;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;

public class SubsetTreeFormHtmlProducer
extends BdfServerHtmlProducer {
    public SubsetTreeFormHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.CODEMIRRORMODE);
        this.addThemeCss("configuration.css");
    }

    @Override
    public void printHtml() {
        CommandBox commandBox = CommandBox.init().action("configuration").family("CNF").veil(true).page("config-subsettree");
        this.start();
        this.printCommandMessageUnit();
        this.DIV("configuration-TreeBoxes").__(this.printGroupDefList()).__(this.printForm(commandBox, (short)1, "_ CNF-13", this.fichotheque.getCorpusList().size())).__(this.printForm(commandBox, (short)2, "_ CNF-14", this.fichotheque.getThesaurusList().size())).__(this.printForm(commandBox, (short)3, "_ CNF-15", this.fichotheque.getSphereList().size())).__(this.printForm(commandBox, (short)5, "_ CNF-16", this.fichotheque.getAlbumList().size())).__(this.printForm(commandBox, (short)4, "_ CNF-17", this.fichotheque.getAddendaList().size()))._DIV();
        this.end();
    }

    private boolean printGroupDefList() {
        List<GroupDef> groupDefList = this.bdfServer.getGroupManager().getGroupDefList();
        if (groupDefList.isEmpty()) {
            return false;
        }
        this.DIV("configuration-GroupList").__(PageUnit.start("_ title.configuration.availablegroups"));
        for (GroupDef groupDef : groupDefList) {
            String title = groupDef.getTitleLabels().seekLabelString(this.workingLang, null);
            this.CODE("cm-operator").__escape('+')._CODE().__space().CODE("cm-component-group").__escape(groupDef.getName())._CODE();
            if (title != null) {
                this.__space().CODE("cm-comment").__escape('(').__escape(title).__escape(')')._CODE();
            }
            this.BR();
        }
        this.__(PageUnit.END)._DIV();
        return true;
    }

    private boolean printForm(CommandBox commandBox, short category, String commandKey, int subsetCount) {
        SubsetTree subsetTree = this.bdfServer.getTreeManager().getSubsetTree(category);
        commandBox = commandBox.derive("SubsetTree", commandKey).hidden("category", SubsetKey.categoryToString(category)).submitLocKey("_ submit.configuration.subsettree").__(Flag.UPDATE_COLLECTIONS);
        if (category == 1) {
            commandBox.__(Flag.UPDATE_CORPUS_TREE);
        }
        this.__start(commandBox).TEXTAREA(HA.name("tree").cols(75).rows(subsetCount + 3).attr("data-codemirror-mode", "subsettree"));
        for (SubsetTree.Node node : subsetTree.getNodeList()) {
            if (node instanceof SubsetNode) {
                this.appendSubsetNode((SubsetNode)node, 0);
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.appendGroupNode((GroupNode)node, 1);
        }
        this._TEXTAREA().__end(commandBox);
        return true;
    }

    private void appendSubsetNode(SubsetNode subsetNode, int indent) {
        for (int i = 0; i < indent; ++i) {
            this.__space().__space();
        }
        SubsetKey subsetKey = subsetNode.getSubsetKey();
        this.__escape(subsetKey);
        Subset subset = this.fichotheque.getSubset(subsetKey);
        if (subset != null) {
            this.__space().__escape('(').__escape(FichothequeUtils.getTitle(subset, this.workingLang)).__escape(')');
        }
        this.__newLine();
    }

    private void appendGroupNode(GroupNode groupNode, int level) {
        int i;
        int i2;
        this.__newLine();
        String name = groupNode.getName();
        for (i2 = 0; i2 < level - 1; ++i2) {
            this.__space().__space();
        }
        for (i2 = 0; i2 < level; ++i2) {
            this.__escape('+');
        }
        this.__space().__escape(name).__space().__escape('(').__escape(TreeUtils.getTitle(this.bdfServer, groupNode, this.workingLang)).__escape(')').__newLine();
        for (SubsetTree.Node subnode : groupNode.getSubnodeList()) {
            if (subnode instanceof SubsetNode) {
                this.appendSubsetNode((SubsetNode)subnode, level + 1);
                continue;
            }
            if (!(subnode instanceof GroupNode)) continue;
            this.appendGroupNode((GroupNode)subnode, level + 1);
        }
        for (i = 0; i < level - 1; ++i) {
            this.__space().__space();
        }
        for (i = 0; i < level; ++i) {
            this.__escape('-');
        }
        this.__space().__escape(name).__newLine().__newLine();
    }
}

